/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;

public final class OpenApiJsonSchemaMapper
implements JsonSchemaMapper {
    private static final Set<String> UNSUPPORTED_KEYWORD_DIRECTIVES = SetUtils.of((Object[])new String[]{"propertyNames", "contentMediaType"});

    public Schema.Builder updateSchema(Shape shape, Schema.Builder builder, JsonSchemaConfig config) {
        OpenApiJsonSchemaMapper.getResolvedExternalDocs(shape, config).map(Component::toNode).ifPresent(docs -> builder.putExtension("externalDocs", (ToNode)docs));
        if (shape.hasTrait(BoxTrait.class)) {
            builder.putExtension("nullable", (ToNode)Node.from((boolean)true));
        }
        if (shape.hasTrait(DeprecatedTrait.class)) {
            builder.putExtension("deprecated", (ToNode)Node.from((boolean)true));
        }
        if ((shape.isByteShape() || shape.isShortShape() || shape.isIntegerShape() || shape.isLongShape()) && config instanceof OpenApiConfig && ((OpenApiConfig)config).getUseIntegerType()) {
            builder.type("integer");
        }
        if (!builder.getFormat().isPresent()) {
            if (shape.isIntegerShape()) {
                builder.format("int32");
            } else if (shape.isLongShape()) {
                builder.format("int64");
            } else if (shape.isFloatShape()) {
                builder.format("float");
            } else if (shape.isDoubleShape()) {
                builder.format("double");
            } else if (shape.isBlobShape()) {
                if (config instanceof OpenApiConfig) {
                    String blobFormat = ((OpenApiConfig)config).getDefaultBlobFormat();
                    return builder.format(blobFormat);
                }
            } else if (shape.hasTrait(SensitiveTrait.class)) {
                builder.format("password");
            }
        }
        UNSUPPORTED_KEYWORD_DIRECTIVES.forEach(arg_0 -> ((Schema.Builder)builder).disableProperty(arg_0));
        return builder;
    }

    static Optional<ExternalDocumentation> getResolvedExternalDocs(Shape shape, JsonSchemaConfig config) {
        Optional traitOptional = shape.getTrait(ExternalDocumentationTrait.class);
        if (!traitOptional.isPresent() || !(config instanceof OpenApiConfig)) {
            return Optional.empty();
        }
        OpenApiConfig openApiConfig = (OpenApiConfig)config;
        ArrayList<String> externalDocKeys = new ArrayList<String>(openApiConfig.getExternalDocs().size());
        for (String key : openApiConfig.getExternalDocs()) {
            externalDocKeys.add(key.toLowerCase(Locale.ENGLISH));
        }
        Map traitUrls = ((ExternalDocumentationTrait)traitOptional.get()).getUrls();
        Map lowercaseKeyMap = (Map)traitUrls.keySet().stream().collect(MapUtils.toUnmodifiableMap(i -> i.toLowerCase(Locale.US), Function.identity()));
        for (String externalDocKey : externalDocKeys) {
            if (!lowercaseKeyMap.containsKey(externalDocKey)) continue;
            String traitKey = (String)lowercaseKeyMap.get(externalDocKey);
            return Optional.of(ExternalDocumentation.builder().description(traitKey).url((String)traitUrls.get(traitKey)).build());
        }
        return Optional.empty();
    }
}

