/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.openapi.model.ServerObject;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class PathItem
extends Component
implements ToSmithyBuilder<PathItem> {
    private final String summary;
    private final String description;
    private final List<ServerObject> servers;
    private final List<Ref<ParameterObject>> parameters;
    private final OperationObject get;
    private final OperationObject put;
    private final OperationObject post;
    private final OperationObject delete;
    private final OperationObject options;
    private final OperationObject head;
    private final OperationObject patch;
    private final OperationObject trace;

    private PathItem(Builder builder) {
        super(builder);
        this.summary = builder.summary;
        this.description = builder.description;
        this.servers = (List)builder.servers.copy();
        this.parameters = (List)builder.parameters.copy();
        this.get = builder.get;
        this.put = builder.put;
        this.post = builder.post;
        this.delete = builder.delete;
        this.options = builder.options;
        this.head = builder.head;
        this.patch = builder.patch;
        this.trace = builder.trace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public List<ServerObject> getServers() {
        return this.servers;
    }

    public List<Ref<ParameterObject>> getParameters() {
        return this.parameters;
    }

    public Optional<OperationObject> getGet() {
        return Optional.ofNullable(this.get);
    }

    public Optional<OperationObject> getPut() {
        return Optional.ofNullable(this.put);
    }

    public Optional<OperationObject> getPost() {
        return Optional.ofNullable(this.post);
    }

    public Optional<OperationObject> getDelete() {
        return Optional.ofNullable(this.delete);
    }

    public Optional<OperationObject> getOptions() {
        return Optional.ofNullable(this.options);
    }

    public Optional<OperationObject> getHead() {
        return Optional.ofNullable(this.head);
    }

    public Optional<OperationObject> getPatch() {
        return Optional.ofNullable(this.patch);
    }

    public Optional<OperationObject> getTrace() {
        return Optional.ofNullable(this.trace);
    }

    public Map<String, OperationObject> getOperations() {
        HashMap<String, OperationObject> operations = new HashMap<String, OperationObject>();
        this.getGet().ifPresent(operation -> operations.put("GET", (OperationObject)operation));
        this.getPut().ifPresent(operation -> operations.put("PUT", (OperationObject)operation));
        this.getPost().ifPresent(operation -> operations.put("POST", (OperationObject)operation));
        this.getDelete().ifPresent(operation -> operations.put("DELETE", (OperationObject)operation));
        this.getOptions().ifPresent(operation -> operations.put("OPTIONS", (OperationObject)operation));
        this.getHead().ifPresent(operation -> operations.put("HEAD", (OperationObject)operation));
        this.getPatch().ifPresent(operation -> operations.put("PATCH", (OperationObject)operation));
        this.getTrace().ifPresent(operation -> operations.put("TRACE", (OperationObject)operation));
        return operations;
    }

    public Stream<OperationObject> operations() {
        return this.getOperations().values().stream();
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("summary", this.getSummary().map(Node::from)).withOptionalMember("delete", this.getDelete()).withOptionalMember("get", this.getGet()).withOptionalMember("head", this.getHead()).withOptionalMember("options", this.getOptions()).withOptionalMember("patch", this.getPatch()).withOptionalMember("post", this.getPost()).withOptionalMember("put", this.getPut()).withOptionalMember("trace", this.getTrace());
        if (!this.parameters.isEmpty()) {
            builder.withMember("parameters", (ToNode)((ArrayNode)this.getParameters().stream().map(ToNode::toNode).collect(ArrayNode.collect())));
        }
        if (!this.servers.isEmpty()) {
            builder.withMember("servers", (ToNode)((ArrayNode)this.getServers().stream().map(Component::toNode).collect(ArrayNode.collect())));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)PathItem.builder().extensions(this.getExtensions())).summary(this.summary).description(this.description).servers(this.servers).parameters(this.parameters).get(this.get).put(this.put).post(this.post).delete(this.delete).options(this.options).head(this.head).patch(this.patch).trace(this.trace);
    }

    public static final class Builder
    extends Component.Builder<Builder, PathItem> {
        private String summary;
        private String description;
        private final BuilderRef<List<ServerObject>> servers = BuilderRef.forList();
        private final BuilderRef<List<Ref<ParameterObject>>> parameters = BuilderRef.forList();
        private OperationObject get;
        private OperationObject put;
        private OperationObject post;
        private OperationObject delete;
        private OperationObject options;
        private OperationObject head;
        private OperationObject patch;
        private OperationObject trace;

        private Builder() {
        }

        public PathItem build() {
            return new PathItem(this);
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder servers(List<ServerObject> servers) {
            this.servers.clear();
            servers.forEach(this::addServer);
            return this;
        }

        public Builder addServer(ServerObject server) {
            ((List)this.servers.get()).add(server);
            return this;
        }

        public Builder parameters(List<Ref<ParameterObject>> parameters) {
            this.parameters.clear();
            parameters.forEach(this::addParameter);
            return this;
        }

        public Builder addParameter(ParameterObject parameter) {
            return this.addParameter(Ref.local(parameter));
        }

        public Builder addParameter(Ref<ParameterObject> parameter) {
            ((List)this.parameters.get()).add(parameter);
            return this;
        }

        public Builder get(OperationObject get) {
            this.get = get;
            return this;
        }

        public Builder put(OperationObject put) {
            this.put = put;
            return this;
        }

        public Builder post(OperationObject post) {
            this.post = post;
            return this;
        }

        public Builder delete(OperationObject delete) {
            this.delete = delete;
            return this;
        }

        public Builder options(OperationObject options) {
            this.options = options;
            return this;
        }

        public Builder head(OperationObject head) {
            this.head = head;
            return this;
        }

        public Builder patch(OperationObject patch) {
            this.patch = patch;
            return this;
        }

        public Builder trace(OperationObject trace) {
            this.trace = trace;
            return this;
        }
    }
}

