/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.CallbackObject;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.LinkObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ComponentsObject
extends Component
implements ToSmithyBuilder<ComponentsObject> {
    private final Map<String, Schema> schemas;
    private final Map<String, ResponseObject> responses;
    private final Map<String, ParameterObject> parameters;
    private final Map<String, RequestBodyObject> requestBodies;
    private final Map<String, ParameterObject> headers;
    private final Map<String, SecurityScheme> securitySchemes;
    private final Map<String, LinkObject> links;
    private final Map<String, CallbackObject> callbacks;

    private ComponentsObject(Builder builder) {
        super(builder);
        this.schemas = new TreeMap<String, Schema>((Map)builder.schemas.peek());
        this.responses = new TreeMap<String, ResponseObject>((Map)builder.responses.peek());
        this.parameters = new TreeMap<String, ParameterObject>((Map)builder.parameters.peek());
        this.requestBodies = new TreeMap<String, RequestBodyObject>((Map)builder.requestBodies.peek());
        this.headers = new TreeMap<String, ParameterObject>((Map)builder.headers.peek());
        this.securitySchemes = new TreeMap<String, SecurityScheme>((Map)builder.securitySchemes.peek());
        this.links = new TreeMap<String, LinkObject>((Map)builder.links.peek());
        this.callbacks = new TreeMap<String, CallbackObject>((Map)builder.callbacks.peek());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Map<String, ResponseObject> getResponses() {
        return this.responses;
    }

    public Map<String, ParameterObject> getParameters() {
        return this.parameters;
    }

    public Map<String, RequestBodyObject> getRequestBodies() {
        return this.requestBodies;
    }

    public Map<String, ParameterObject> getHeaders() {
        return this.headers;
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public Map<String, LinkObject> getLinks() {
        return this.links;
    }

    public Map<String, CallbackObject> getCallbacks() {
        return this.callbacks;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (!this.schemas.isEmpty()) {
            builder.withMember("schemas", (ToNode)((ObjectNode)this.schemas.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.responses.isEmpty()) {
            builder.withMember("responses", (ToNode)((ObjectNode)this.responses.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.parameters.isEmpty()) {
            builder.withMember("parameters", (ToNode)((ObjectNode)this.parameters.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.requestBodies.isEmpty()) {
            builder.withMember("requestBodies", (ToNode)((ObjectNode)this.requestBodies.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.headers.isEmpty()) {
            builder.withMember("headers", (ToNode)((ObjectNode)this.headers.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.securitySchemes.isEmpty()) {
            builder.withMember("securitySchemes", (ToNode)((ObjectNode)this.securitySchemes.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.links.isEmpty()) {
            builder.withMember("links", (ToNode)((ObjectNode)this.links.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        if (!this.callbacks.isEmpty()) {
            builder.withMember("callbacks", (ToNode)((ObjectNode)this.callbacks.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder;
    }

    public Builder toBuilder() {
        return (Builder)ComponentsObject.builder().schemas(this.schemas).responses(this.responses).parameters(this.parameters).requestBodies(this.requestBodies).headers(this.headers).securitySchemes(this.securitySchemes).links(this.links).callbacks(this.callbacks).extensions(this.getExtensions());
    }

    public static final class Builder
    extends Component.Builder<Builder, ComponentsObject> {
        private final BuilderRef<Map<String, Schema>> schemas = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, ResponseObject>> responses = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, ParameterObject>> parameters = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, RequestBodyObject>> requestBodies = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, ParameterObject>> headers = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, SecurityScheme>> securitySchemes = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, LinkObject>> links = BuilderRef.forSortedMap();
        private final BuilderRef<Map<String, CallbackObject>> callbacks = BuilderRef.forSortedMap();

        private Builder() {
        }

        public ComponentsObject build() {
            return new ComponentsObject(this);
        }

        public Builder schemas(Map<String, Schema> schemas) {
            this.schemas.clear();
            schemas.forEach(this::putSchema);
            return this;
        }

        public Builder putSchema(String name, Schema schema) {
            ((Map)this.schemas.get()).put(name, schema);
            return this;
        }

        public Builder removeSchema(String name) {
            ((Map)this.schemas.get()).remove(name);
            return this;
        }

        public Builder responses(Map<String, ResponseObject> responses) {
            this.responses.clear();
            responses.forEach(this::putResponse);
            return this;
        }

        public Builder putResponse(String name, ResponseObject response) {
            ((Map)this.responses.get()).put(name, response);
            return this;
        }

        public Builder parameters(Map<String, ParameterObject> parameters) {
            this.parameters.clear();
            parameters.forEach(this::putParameter);
            return this;
        }

        public Builder putParameter(String name, ParameterObject parameter) {
            ((Map)this.parameters.get()).put(name, parameter);
            return this;
        }

        public Builder requestBodies(Map<String, RequestBodyObject> requestBodies) {
            this.requestBodies.clear();
            requestBodies.forEach(this::putRequestBodies);
            return this;
        }

        public Builder putRequestBodies(String name, RequestBodyObject requestBody) {
            ((Map)this.requestBodies.get()).put(name, requestBody);
            return this;
        }

        public Builder headers(Map<String, ParameterObject> headers) {
            this.headers.clear();
            headers.forEach(this::putHeader);
            return this;
        }

        public Builder putHeader(String name, ParameterObject header) {
            ((Map)this.headers.get()).put(name, header);
            return this;
        }

        public Builder securitySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes.clear();
            securitySchemes.forEach(this::putSecurityScheme);
            return this;
        }

        public Builder putSecurityScheme(String name, SecurityScheme securityScheme) {
            ((Map)this.securitySchemes.get()).put(name, securityScheme);
            return this;
        }

        public Builder removeSecurityScheme(String name) {
            ((Map)this.securitySchemes.get()).remove(name);
            return this;
        }

        public Builder links(Map<String, LinkObject> links) {
            this.links.clear();
            links.forEach(this::putLink);
            return this;
        }

        public Builder putLink(String name, LinkObject link) {
            ((Map)this.links.get()).put(name, link);
            return this;
        }

        public Builder callbacks(Map<String, CallbackObject> callbacks) {
            this.callbacks.clear();
            callbacks.forEach(this::putCallbacks);
            return this;
        }

        public Builder putCallbacks(String name, CallbackObject callback) {
            ((Map)this.callbacks.get()).put(name, callback);
            return this;
        }
    }
}

