/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.OpenApiProtocol;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;

public final class Context<T extends Trait> {
    private final Model model;
    private final ServiceShape service;
    private final JsonSchemaConverter jsonSchemaConverter;
    private final T protocolTrait;
    private final OpenApiProtocol<T> openApiProtocol;
    private final SchemaDocument schemas;
    private final List<SecuritySchemeConverter<? extends Trait>> securitySchemeConverters;
    private Map<String, Schema> synthesizedSchemas = Collections.synchronizedMap(new TreeMap());
    private OpenApiConfig config;

    Context(Model model, ServiceShape service, OpenApiConfig config, JsonSchemaConverter jsonSchemaConverter, OpenApiProtocol<T> openApiProtocol, SchemaDocument schemas, List<SecuritySchemeConverter<? extends Trait>> securitySchemeConverters) {
        this.model = model;
        this.service = service;
        this.config = config;
        this.jsonSchemaConverter = jsonSchemaConverter;
        this.protocolTrait = service.expectTrait(openApiProtocol.getProtocolType());
        this.openApiProtocol = openApiProtocol;
        this.schemas = schemas;
        this.securitySchemeConverters = securitySchemeConverters;
    }

    public Model getModel() {
        return this.model;
    }

    public ServiceShape getService() {
        return this.service;
    }

    public OpenApiConfig getConfig() {
        return this.config;
    }

    public JsonSchemaConverter getJsonSchemaConverter() {
        return this.jsonSchemaConverter;
    }

    public T getProtocolTrait() {
        return this.protocolTrait;
    }

    public OpenApiProtocol<T> getOpenApiProtocol() {
        return this.openApiProtocol;
    }

    public Schema getSchema(String pointer) {
        return (Schema)this.schemas.getDefinition(pointer).orElseThrow(() -> new OpenApiException("Expected JSON schema definition not found: " + pointer));
    }

    public String getPointer(ToShapeId shapeId) {
        return this.getJsonSchemaConverter().toPointer((ToShapeId)shapeId.toShapeId());
    }

    public Schema createRef(ToShapeId shapeId) {
        return Schema.builder().ref(this.getPointer(shapeId)).build();
    }

    public Schema inlineOrReferenceSchema(MemberShape member) {
        if (this.getJsonSchemaConverter().isInlined((Shape)member)) {
            return this.getJsonSchemaConverter().convertShape((Shape)member).getRootSchema();
        }
        return this.createRef((ToShapeId)member);
    }

    public List<SecuritySchemeConverter<? extends Trait>> getSecuritySchemeConverters() {
        return this.securitySchemeConverters;
    }

    public boolean usesHttpCredentials() {
        return this.getSecuritySchemeConverters().stream().anyMatch(SecuritySchemeConverter::usesHttpCredentials);
    }

    public Set<String> getAllSecuritySchemeRequestHeaders() {
        TreeSet<String> headers = new TreeSet<String>();
        for (SecuritySchemeConverter<Trait> converter : this.getSecuritySchemeConverters()) {
            headers.addAll(Context.getSecuritySchemeRequestHeaders(this, converter));
        }
        return headers;
    }

    public Set<String> getAllSecuritySchemeResponseHeaders() {
        TreeSet<String> headers = new TreeSet<String>();
        for (SecuritySchemeConverter<Trait> converter : this.getSecuritySchemeConverters()) {
            headers.addAll(Context.getSecuritySchemeResponseHeaders(this, converter));
        }
        return headers;
    }

    private static <T extends Trait> Set<String> getSecuritySchemeRequestHeaders(Context<? extends Trait> context, SecuritySchemeConverter<T> converter) {
        Trait t = context.getService().expectTrait(converter.getAuthSchemeType());
        return converter.getAuthRequestHeaders(context, t);
    }

    private static <T extends Trait> Set<String> getSecuritySchemeResponseHeaders(Context<? extends Trait> context, SecuritySchemeConverter<T> converter) {
        Trait t = context.getService().expectTrait(converter.getAuthSchemeType());
        return converter.getAuthResponseHeaders(context, t);
    }

    public Map<String, Schema> getSynthesizedSchemas() {
        return Collections.unmodifiableMap(this.synthesizedSchemas);
    }

    public String putSynthesizedSchema(String name, Schema schema) {
        this.synthesizedSchemas.put(Objects.requireNonNull(name), Objects.requireNonNull(schema));
        return this.config.getDefinitionPointer() + "/" + name;
    }
}

