/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class XmlObject
extends Component
implements ToSmithyBuilder<XmlObject> {
    private final String name;
    private final String namespace;
    private final String prefix;
    private final boolean attribute;
    private final boolean wrapped;

    private XmlObject(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.prefix = builder.prefix;
        this.attribute = builder.attribute;
        this.wrapped = builder.wrapped;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("name", this.getName().map(Node::from)).withOptionalMember("namespace", this.getNamespace().map(Node::from)).withOptionalMember("prefix", this.getPrefix().map(Node::from));
        if (this.isWrapped()) {
            builder.withMember("wrapped", (ToNode)Node.from((boolean)true));
        }
        if (this.isAttribute()) {
            builder.withMember("attribute", (ToNode)Node.from((boolean)true));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)XmlObject.builder().extensions(this.getExtensions())).name(this.name).namespace(this.namespace).prefix(this.prefix).attribute(this.attribute).wrapped(this.wrapped);
    }

    public static final class Builder
    extends Component.Builder<Builder, XmlObject> {
        private String name;
        private String namespace;
        private String prefix;
        private boolean attribute;
        private boolean wrapped;

        private Builder() {
        }

        public XmlObject build() {
            return new XmlObject(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder attribute(boolean attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder wrapped(boolean wrapped) {
            this.wrapped = wrapped;
            return this;
        }
    }
}

