/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.Ref;

final class LocalRef<T extends ToNode>
extends Ref<T> {
    private T value;

    LocalRef(T value) {
        this.value = value;
    }

    @Override
    public T deref(ComponentsObject components) {
        return this.value;
    }

    @Override
    public Optional<String> getPointer() {
        return Optional.empty();
    }

    public Node toNode() {
        return this.value.toNode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalRef)) {
            return false;
        }
        LocalRef ref = (LocalRef)o;
        return Objects.equals(this.value, ref.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

