/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.CallbackObject;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ExternalDocumentation;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.ServerObject;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class OperationObject
extends Component
implements ToSmithyBuilder<OperationObject> {
    private final String summary;
    private final String description;
    private final ExternalDocumentation externalDocs;
    private final String operationId;
    private final RequestBodyObject requestBody;
    private final boolean deprecated;
    private final List<String> tags;
    private final List<ParameterObject> parameters;
    private final Map<String, ResponseObject> responses;
    private final Map<String, CallbackObject> callbacks;
    private final List<Map<String, List<String>>> security;
    private final List<ServerObject> servers;

    private OperationObject(Builder builder) {
        super(builder);
        this.tags = ListUtils.copyOf((Collection)builder.tags);
        this.summary = builder.summary;
        this.description = builder.description;
        this.externalDocs = builder.externalDocs;
        this.operationId = builder.operationId;
        this.parameters = ListUtils.copyOf((Collection)builder.parameters);
        this.requestBody = builder.requestBody;
        this.responses = Collections.unmodifiableMap(new TreeMap(builder.responses));
        this.deprecated = builder.deprecated;
        this.callbacks = Collections.unmodifiableMap(new TreeMap(builder.callbacks));
        this.security = builder.security != null ? ListUtils.copyOf((Collection)builder.security) : null;
        this.servers = ListUtils.copyOf((Collection)builder.servers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(this.summary);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<ExternalDocumentation> getExternalDocs() {
        return Optional.ofNullable(this.externalDocs);
    }

    public Optional<String> getOperationId() {
        return Optional.ofNullable(this.operationId);
    }

    public List<ParameterObject> getParameters() {
        return this.parameters;
    }

    public Optional<RequestBodyObject> getRequestBody() {
        return Optional.ofNullable(this.requestBody);
    }

    public Map<String, ResponseObject> getResponses() {
        return this.responses;
    }

    public Map<String, CallbackObject> getCallbacks() {
        return this.callbacks;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Optional<List<Map<String, List<String>>>> getSecurity() {
        return Optional.ofNullable(this.security);
    }

    public List<ServerObject> getServers() {
        return this.servers;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("summary", this.getSummary().map(Node::from)).withOptionalMember("externalDocs", this.getExternalDocs()).withOptionalMember("operationId", this.getOperationId().map(Node::from)).withOptionalMember("requestBody", this.getRequestBody());
        if (this.isDeprecated()) {
            builder.withMember("deprecated", (ToNode)Node.from((boolean)true));
        }
        if (!this.parameters.isEmpty()) {
            builder.withMember("parameters", (ToNode)this.getParameters().stream().collect(ArrayNode.collect()));
        }
        if (!this.responses.isEmpty()) {
            builder.withMember("responses", (ToNode)this.getResponses().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (!this.callbacks.isEmpty()) {
            builder.withMember("callbacks", (ToNode)this.getCallbacks().entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (this.getSecurity().isPresent()) {
            builder.withMember("security", (ToNode)this.getSecurity().get().stream().map(map -> (ObjectNode)map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> Pair.of(entry.getKey(), ((List)entry.getValue()).stream().map(Node::from).collect(ArrayNode.collect()))).collect(ObjectNode.collectStringKeys(Pair::getLeft, Pair::getRight))).collect(ArrayNode.collect()));
        }
        if (!this.servers.isEmpty()) {
            builder.withMember("servers", (ToNode)this.getServers().stream().map(Component::toNode).collect(ArrayNode.collect()));
        }
        if (!this.tags.isEmpty()) {
            builder.withMember("tags", (ToNode)this.getTags().stream().map(Node::from).collect(ArrayNode.collect()));
        }
        return builder;
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)OperationObject.builder().extensions(this.getExtensions())).callbacks(this.callbacks).responses(this.responses).parameters(this.parameters).servers(this.servers).summary(this.summary).tags(this.tags).deprecated(this.deprecated).description(this.description).externalDocs(this.externalDocs).operationId(this.operationId).requestBody(this.requestBody);
        this.getSecurity().ifPresent(builder::security);
        return builder;
    }

    public static final class Builder
    extends Component.Builder<Builder, OperationObject> {
        private final List<String> tags = new ArrayList<String>();
        private final List<ParameterObject> parameters = new ArrayList<ParameterObject>();
        private final Map<String, ResponseObject> responses = new TreeMap<String, ResponseObject>();
        private final Map<String, CallbackObject> callbacks = new TreeMap<String, CallbackObject>();
        private Set<Map<String, List<String>>> security;
        private final List<ServerObject> servers = new ArrayList<ServerObject>();
        private String summary;
        private String description;
        private ExternalDocumentation externalDocs;
        private String operationId;
        private RequestBodyObject requestBody;
        private boolean deprecated;

        private Builder() {
        }

        public OperationObject build() {
            return new OperationObject(this);
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder externalDocs(ExternalDocumentation externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder parameters(Collection<ParameterObject> parameters) {
            this.parameters.clear();
            this.parameters.addAll(parameters);
            return this;
        }

        public Builder addParameter(ParameterObject parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Builder requestBody(RequestBodyObject requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder responses(Map<String, ResponseObject> responses) {
            this.responses.clear();
            this.responses.putAll(responses);
            return this;
        }

        public Builder putResponse(String statusCode, ResponseObject response) {
            this.responses.put(statusCode, response);
            return this;
        }

        public Builder callbacks(Map<String, CallbackObject> callbacks) {
            this.callbacks.clear();
            this.callbacks.putAll(callbacks);
            return this;
        }

        public Builder putCallback(String expression, CallbackObject callback) {
            this.callbacks.put(expression, callback);
            return this;
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder security(Collection<Map<String, List<String>>> security) {
            this.security = new LinkedHashSet<Map<String, List<String>>>();
            this.security.addAll(security);
            return this;
        }

        public Builder addSecurity(Map<String, List<String>> security) {
            if (this.security == null) {
                this.security = new LinkedHashSet<Map<String, List<String>>>();
            }
            this.security.add(security);
            return this;
        }

        public Builder servers(Collection<ServerObject> servers) {
            this.servers.clear();
            this.servers.addAll(servers);
            return this;
        }

        public Builder addServer(ServerObject server) {
            this.servers.add(server);
            return this;
        }
    }
}

