/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TitleTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiJsonSchemaMapper;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.fromsmithy.OpenApiProtocol;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.fromsmithy.Smithy2OpenApiExtension;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.InfoObject;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.openapi.model.TagObject;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Tagged;

public final class OpenApiConverter {
    private static final Logger LOGGER = Logger.getLogger(OpenApiConverter.class.getName());
    private ClassLoader classLoader = OpenApiConverter.class.getClassLoader();
    private OpenApiConfig config = new OpenApiConfig();
    private final List<OpenApiMapper> mappers = new ArrayList<OpenApiMapper>();

    private OpenApiConverter() {
    }

    public static OpenApiConverter create() {
        return new OpenApiConverter();
    }

    public OpenApiConfig getConfig() {
        return this.config;
    }

    public OpenApiConverter config(OpenApiConfig config) {
        this.config = config;
        return this;
    }

    public OpenApiConverter addOpenApiMapper(OpenApiMapper mapper) {
        this.mappers.add(mapper);
        return this;
    }

    public OpenApiConverter classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public OpenApi convert(Model model) {
        return this.convertWithEnvironment(this.createConversionEnvironment(model));
    }

    public ObjectNode convertToNode(Model model) {
        ConversionEnvironment<? extends Trait> environment = this.createConversionEnvironment(model);
        OpenApi openApi = this.convertWithEnvironment(environment);
        ObjectNode node = openApi.toNode().expectObjectNode();
        return ((ConversionEnvironment)environment).mapper.updateNode(((ConversionEnvironment)environment).context, openApi, node);
    }

    private ConversionEnvironment<? extends Trait> createConversionEnvironment(Model model) {
        ShapeId serviceShapeId = this.config.getService();
        if (serviceShapeId == null) {
            throw new OpenApiException("openapi is missing required property, `service`");
        }
        JsonSchemaConverter.Builder jsonSchemaConverterBuilder = JsonSchemaConverter.builder();
        jsonSchemaConverterBuilder.model(model);
        ArrayList<Smithy2OpenApiExtension> extensions = new ArrayList<Smithy2OpenApiExtension>();
        for (Smithy2OpenApiExtension extension : ServiceLoader.load(Smithy2OpenApiExtension.class, this.classLoader)) {
            extensions.add(extension);
            for (JsonSchemaMapper mapper : extension.getJsonSchemaMappers()) {
                jsonSchemaConverterBuilder.addMapper(mapper);
            }
        }
        ServiceShape service = (ServiceShape)((Shape)model.getShape(serviceShapeId).orElseThrow(() -> new IllegalArgumentException(String.format("Shape `%s` not found in model", serviceShapeId)))).asServiceShape().orElseThrow(() -> new IllegalArgumentException(String.format("Shape `%s` is not a service shape", serviceShapeId)));
        Trait protocolTrait = this.loadOrDeriveProtocolTrait(model, service);
        OpenApiProtocol<Trait> openApiProtocol = this.loadOpenApiProtocol(service, protocolTrait, extensions);
        OpenApiMapper composedMapper = OpenApiConverter.createComposedMapper(extensions, this.mappers);
        composedMapper.updateDefaultSettings(model, this.config);
        openApiProtocol.updateDefaultSettings(model, this.config);
        jsonSchemaConverterBuilder.config((JsonSchemaConfig)this.config);
        jsonSchemaConverterBuilder.rootShape((ToShapeId)service);
        JsonSchemaConverter jsonSchemaConverter = jsonSchemaConverterBuilder.build();
        SchemaDocument document = jsonSchemaConverter.convert();
        ComponentsObject.Builder components = ComponentsObject.builder();
        for (Map.Entry entry : document.getDefinitions().entrySet()) {
            String key = ((String)entry.getKey()).replace(this.config.getDefinitionPointer() + "/", "");
            components.putSchema(key, (Schema)entry.getValue());
        }
        List<SecuritySchemeConverter<? extends Trait>> securitySchemeConverters = this.loadSecuritySchemes(model, service, extensions);
        Context<Trait> context = new Context<Trait>(model, service, this.config, jsonSchemaConverter, openApiProtocol, document, securitySchemeConverters);
        return new ConversionEnvironment(context, extensions, components, composedMapper);
    }

    private static OpenApiMapper createComposedMapper(List<Smithy2OpenApiExtension> extensions, List<OpenApiMapper> mappers) {
        return OpenApiMapper.compose(Stream.concat(extensions.stream().flatMap(extension -> extension.getOpenApiMappers().stream()), mappers.stream()).collect(Collectors.toList()));
    }

    private Trait loadOrDeriveProtocolTrait(Model model, ServiceShape service) {
        ServiceIndex serviceIndex = (ServiceIndex)model.getKnowledge(ServiceIndex.class);
        Set serviceProtocols = serviceIndex.getProtocols((ToShapeId)service).keySet();
        if (this.config.getProtocol() != null) {
            ShapeId protocolTraitId = this.config.getProtocol();
            return (Trait)service.findTrait(protocolTraitId).orElseThrow(() -> new OpenApiException(String.format("Unable to find protocol `%s` on service `%s`. This service supports the following protocols: %s", protocolTraitId, service.getId(), serviceProtocols)));
        }
        if (serviceProtocols.isEmpty()) {
            throw new OpenApiException(String.format("No Smithy protocol was configured and `%s` does not define any protocols.", service.getId()));
        }
        if (serviceProtocols.size() > 1) {
            throw new OpenApiException(String.format("No Smithy protocol was configured and `%s` defines multiple protocols: %s", service.getId(), serviceProtocols));
        }
        return (Trait)serviceIndex.getProtocols((ToShapeId)service).values().iterator().next();
    }

    private <T extends Trait> OpenApi convertWithEnvironment(ConversionEnvironment<T> environment) {
        ServiceShape service = ((ConversionEnvironment)environment).context.getService();
        Context context = ((ConversionEnvironment)environment).context;
        OpenApiMapper mapper = ((ConversionEnvironment)environment).mapper;
        OpenApiProtocol openApiProtocol = ((ConversionEnvironment)environment).context.getOpenApiProtocol();
        OpenApi.Builder openapi = OpenApi.builder().openapi("3.0.2").info(this.createInfo(service));
        mapper.before(context, openapi);
        OpenApiJsonSchemaMapper.getResolvedExternalDocs((Shape)service, context.getConfig()).ifPresent(openapi::externalDocs);
        for (String string : this.getSupportedTags((Tagged)service)) {
            openapi.addTag(TagObject.builder().name(string).build());
        }
        this.addPaths(context, openapi, openApiProtocol, mapper);
        this.addSecurityComponents(context, openapi, ((ConversionEnvironment)environment).components, mapper);
        for (Map.Entry entry : context.getSynthesizedSchemas().entrySet()) {
            ((ConversionEnvironment)environment).components.putSchema((String)entry.getKey(), (Schema)entry.getValue());
        }
        openapi.components(((ConversionEnvironment)environment).components.build());
        openapi.extensions(context.getConfig().getSchemaDocumentExtensions());
        return mapper.after(context, openapi.build());
    }

    private <T extends Trait> OpenApiProtocol<T> loadOpenApiProtocol(ServiceShape service, T protocolTrait, List<Smithy2OpenApiExtension> extensions) {
        List protocolProviders = extensions.stream().flatMap(e -> e.getProtocols().stream()).collect(Collectors.toList());
        return protocolProviders.stream().filter(openApiProtocol -> openApiProtocol.getProtocolType().equals(protocolTrait.getClass())).findFirst().map(result -> result).orElseThrow(() -> {
            Stream<String> supportedProtocols = protocolProviders.stream().map(OpenApiProtocol::getProtocolType).map(Class::getCanonicalName);
            return new OpenApiException(String.format("Unable to find an OpenAPI service provider for the `%s` protocol when converting `%s`. Protocol service providers were found for the following protocol classes: [%s].", protocolTrait.toShapeId(), service.getId(), ValidationUtils.tickedList(supportedProtocols)));
        });
    }

    private List<SecuritySchemeConverter<? extends Trait>> loadSecuritySchemes(Model model, ServiceShape service, List<Smithy2OpenApiExtension> extensions) {
        ServiceIndex serviceIndex = (ServiceIndex)model.getKnowledge(ServiceIndex.class);
        Set<Class<? extends Trait>> schemes = this.getTraitMapTypes(serviceIndex.getAuthSchemes((ToShapeId)service));
        List converters = extensions.stream().flatMap(extension -> extension.getSecuritySchemeConverters().stream()).collect(Collectors.toList());
        ArrayList<SecuritySchemeConverter<? extends Trait>> resolved = new ArrayList<SecuritySchemeConverter<? extends Trait>>();
        for (SecuritySchemeConverter converter : converters) {
            if (!schemes.remove(converter.getAuthSchemeType())) continue;
            resolved.add(converter);
        }
        if (!schemes.isEmpty()) {
            LOGGER.warning(() -> String.format("Unable to find an OpenAPI authentication converter for the following schemes: [%s]", schemes));
        }
        return resolved;
    }

    private List<String> getSupportedTags(Tagged tagged) {
        if (!this.config.getTags()) {
            return Collections.emptyList();
        }
        List<String> supported = this.config.getSupportedTags();
        return tagged.getTags().stream().filter(tag -> supported == null || supported.contains(tag)).collect(Collectors.toList());
    }

    private InfoObject createInfo(ServiceShape service) {
        InfoObject.Builder infoBuilder = InfoObject.builder();
        service.getTrait(DocumentationTrait.class).ifPresent(trait -> infoBuilder.description(trait.getValue()));
        infoBuilder.version(service.getVersion());
        infoBuilder.title(service.getTrait(TitleTrait.class).map(StringTrait::getValue).orElse(service.getId().getName()));
        return infoBuilder.build();
    }

    private <T extends Trait> void addPaths(Context<T> context, OpenApi.Builder openApiBuilder, OpenApiProtocol<T> protocolService, OpenApiMapper plugin) {
        TopDownIndex topDownIndex = (TopDownIndex)context.getModel().getKnowledge(TopDownIndex.class);
        HashMap paths = new HashMap();
        topDownIndex.getContainedOperations((ToShapeId)context.getService()).forEach(shape -> OptionalUtils.ifPresentOrElse(protocolService.createOperation(context, (OperationShape)shape), result -> {
            String method = result.getMethod();
            String path = result.getUri();
            PathItem.Builder pathItem = paths.computeIfAbsent(result.getUri(), uri -> PathItem.builder());
            if (shape.hasTrait(DeprecatedTrait.class)) {
                result.getOperation().deprecated(true);
            }
            this.addOperationSecurity(context, result.getOperation(), (OperationShape)shape, plugin);
            OperationObject builtOperation = plugin.updateOperation(context, (OperationShape)shape, result.getOperation().build(), method, path);
            builtOperation = this.addOperationTags(context, (Shape)shape, builtOperation);
            builtOperation = this.updateParameters(context, (OperationShape)shape, builtOperation, method, path, plugin);
            builtOperation = this.updateResponses(context, (OperationShape)shape, builtOperation, method, path, plugin);
            builtOperation = this.updateRequestBody(context, (OperationShape)shape, builtOperation, method, path, plugin);
            switch (method.toLowerCase(Locale.ENGLISH)) {
                case "get": {
                    pathItem.get(builtOperation);
                    break;
                }
                case "put": {
                    pathItem.put(builtOperation);
                    break;
                }
                case "delete": {
                    pathItem.delete(builtOperation);
                    break;
                }
                case "post": {
                    pathItem.post(builtOperation);
                    break;
                }
                case "patch": {
                    pathItem.patch(builtOperation);
                    break;
                }
                case "head": {
                    pathItem.head(builtOperation);
                    break;
                }
                case "trace": {
                    pathItem.trace(builtOperation);
                    break;
                }
                case "options": {
                    pathItem.options(builtOperation);
                    break;
                }
                default: {
                    LOGGER.warning(String.format("The %s HTTP method of `%s` is not supported by OpenAPI", result.getMethod(), shape.getId()));
                }
            }
        }, () -> LOGGER.warning(String.format("The `%s` operation is not supported by the `%s` protocol (implemented by `%s`), and was omitted", shape.getId(), protocolService.getClass().getName(), context.getProtocolTrait().toShapeId()))));
        for (Map.Entry entry : paths.entrySet()) {
            String pathName = (String)entry.getKey();
            PathItem pathItem = plugin.updatePathItem(context, pathName, ((PathItem.Builder)entry.getValue()).build());
            openApiBuilder.putPath(pathName, pathItem);
        }
    }

    private <T extends Trait> void addOperationSecurity(Context<T> context, OperationObject.Builder builder, OperationShape shape, OpenApiMapper plugin) {
        ServiceShape service = context.getService();
        ServiceIndex serviceIndex = (ServiceIndex)context.getModel().getKnowledge(ServiceIndex.class);
        Map serviceSchemes = serviceIndex.getEffectiveAuthSchemes((ToShapeId)service);
        Map operationSchemes = serviceIndex.getEffectiveAuthSchemes((ToShapeId)service, (ToShapeId)shape);
        if (shape.getTrait(AuthTrait.class).map(trait -> trait.getValues().isEmpty()).orElse(false).booleanValue()) {
            builder.security(Collections.emptyList());
            return;
        }
        if (!operationSchemes.equals(serviceSchemes)) {
            Set<Class<? extends Trait>> authSchemeClasses = this.getTraitMapTypes(operationSchemes);
            Collection<SecuritySchemeConverter<? extends Trait>> converters = this.findMatchingConverters(context, authSchemeClasses);
            for (SecuritySchemeConverter<? extends Trait> converter : converters) {
                List<String> result = this.createSecurityRequirements(context, converter, service);
                String openApiAuthName = converter.getOpenApiAuthSchemeName();
                Map authMap = MapUtils.of((Object)openApiAuthName, result);
                Map<String, List<String>> requirement = plugin.updateSecurity(context, (Shape)shape, converter, authMap);
                if (requirement == null) continue;
                builder.addSecurity(requirement);
            }
        }
    }

    private <P extends Trait, A extends Trait> List<String> createSecurityRequirements(Context<P> context, SecuritySchemeConverter<A> converter, ServiceShape service) {
        return converter.createSecurityRequirements(context, service.expectTrait(converter.getAuthSchemeType()), (Shape)context.getService());
    }

    private OperationObject addOperationTags(Context<? extends Trait> context, Shape shape, OperationObject operation) {
        if (context.getConfig().getTags()) {
            return operation.toBuilder().tags(this.getSupportedTags((Tagged)shape)).build();
        }
        return operation;
    }

    private <T extends Trait> OperationObject updateParameters(Context<T> context, OperationShape shape, OperationObject operation, String method, String path, OpenApiMapper plugin) {
        ArrayList<ParameterObject> parameters = new ArrayList<ParameterObject>();
        for (ParameterObject parameter : operation.getParameters()) {
            parameters.add(plugin.updateParameter(context, shape, method, path, parameter));
        }
        return !parameters.equals(operation.getParameters()) ? operation.toBuilder().parameters(parameters).build() : operation;
    }

    private <T extends Trait> OperationObject updateRequestBody(Context<T> context, OperationShape shape, OperationObject operation, String method, String path, OpenApiMapper plugin) {
        return operation.getRequestBody().map(body -> {
            RequestBodyObject updatedBody = plugin.updateRequestBody(context, shape, method, path, (RequestBodyObject)body);
            return body.equals(updatedBody) ? operation : operation.toBuilder().requestBody(updatedBody).build();
        }).orElse(operation);
    }

    private <T extends Trait> OperationObject updateResponses(Context<T> context, OperationShape shape, OperationObject operation, String methodName, String path, OpenApiMapper plugin) {
        LinkedHashMap<String, ResponseObject> newResponses = new LinkedHashMap<String, ResponseObject>();
        Map originalResponses = operation.getResponses();
        if (operation.getResponses().isEmpty()) {
            String code = context.getOpenApiProtocol().getOperationResponseStatusCode(context, (ToShapeId)shape);
            originalResponses = MapUtils.of((Object)code, (Object)ResponseObject.builder().description(shape.getId().getName() + " response").build());
        }
        for (Map.Entry<String, ResponseObject> entry : originalResponses.entrySet()) {
            String status = entry.getKey();
            ResponseObject responseObject = plugin.updateResponse(context, shape, status, methodName, path, entry.getValue());
            newResponses.put(status, responseObject);
        }
        if (newResponses.equals(operation.getResponses())) {
            return operation;
        }
        return operation.toBuilder().responses(newResponses).build();
    }

    private <T extends Trait> void addSecurityComponents(Context<T> context, OpenApi.Builder openApiBuilder, ComponentsObject.Builder components, OpenApiMapper plugin) {
        ServiceShape service = context.getService();
        ServiceIndex serviceIndex = (ServiceIndex)context.getModel().getKnowledge(ServiceIndex.class);
        for (SecuritySchemeConverter<Trait> converter : context.getSecuritySchemeConverters()) {
            SecurityScheme createdScheme = this.createAndUpdateSecurityScheme(context, plugin, converter, service);
            if (createdScheme == null) continue;
            components.putSecurityScheme(converter.getOpenApiAuthSchemeName(), createdScheme);
        }
        Map authTraitMap = serviceIndex.getEffectiveAuthSchemes((ToShapeId)context.getService());
        Set<Class<? extends Trait>> defaultAuthTraits = this.getTraitMapTypes(authTraitMap);
        for (SecuritySchemeConverter<Trait> converter : context.getSecuritySchemeConverters()) {
            if (!defaultAuthTraits.contains(converter.getAuthSchemeType())) continue;
            List<String> result = this.createSecurityRequirements(context, converter, context.getService());
            String authSchemeName = converter.getOpenApiAuthSchemeName();
            Map<String, List<String>> requirement = plugin.updateSecurity(context, (Shape)context.getService(), converter, MapUtils.of((Object)authSchemeName, result));
            if (requirement == null) continue;
            openApiBuilder.addSecurity(requirement);
        }
    }

    private Set<Class<? extends Trait>> getTraitMapTypes(Map<ShapeId, Trait> traitMap) {
        return traitMap.values().stream().map(Object::getClass).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <P extends Trait, A extends Trait> SecurityScheme createAndUpdateSecurityScheme(Context<P> context, OpenApiMapper plugin, SecuritySchemeConverter<A> converter, ServiceShape service) {
        Trait authTrait = service.expectTrait(converter.getAuthSchemeType());
        SecurityScheme createdScheme = converter.createSecurityScheme(context, authTrait);
        return plugin.updateSecurityScheme(context, authTrait, createdScheme);
    }

    private Collection<SecuritySchemeConverter<? extends Trait>> findMatchingConverters(Context<? extends Trait> context, Collection<Class<? extends Trait>> schemes) {
        return context.getSecuritySchemeConverters().stream().filter(converter -> schemes.contains(converter.getAuthSchemeType())).map(converter -> converter).collect(Collectors.toList());
    }

    private static final class ConversionEnvironment<T extends Trait> {
        private final Context<T> context;
        private final List<Smithy2OpenApiExtension> extensions;
        private final ComponentsObject.Builder components;
        private final OpenApiMapper mapper;

        private ConversionEnvironment(Context<T> context, List<Smithy2OpenApiExtension> extensions, ComponentsObject.Builder components, OpenApiMapper composedMapper) {
            this.context = context;
            this.extensions = extensions;
            this.components = components;
            this.mapper = composedMapper;
        }
    }
}

