/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy;

import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.SetUtils;

public class OpenApiJsonSchemaMapper
implements JsonSchemaMapper {
    private static final Logger LOGGER = Logger.getLogger(OpenApiJsonSchemaMapper.class.getName());
    private static final String DEFAULT_BLOB_FORMAT = "byte";
    private static final Set<String> UNSUPPORTED_KEYWORD_DIRECTIVES = SetUtils.of((Object[])new String[]{"disable.propertyNames", "disable.contentMediaType"});

    public Schema.Builder updateSchema(Shape shape, Schema.Builder builder, ObjectNode config) {
        boolean enabled = config.getBooleanMemberOrDefault("openapi.mode");
        if (enabled || config.getBooleanMemberOrDefault("openapi.use.externalDocs")) {
            shape.getTrait(ExternalDocumentationTrait.class).map(StringTrait::getValue).ifPresent(docs -> builder.putExtension("externalDocs", (ToNode)Node.from((String)docs)));
        }
        if ((enabled || config.getBooleanMemberOrDefault("openapi.use.nullable")) && shape.hasTrait(BoxTrait.class)) {
            builder.putExtension("nullable", (ToNode)Node.from((boolean)true));
        }
        if ((enabled || config.getBooleanMemberOrDefault("openapi.use.deprecated")) && shape.hasTrait(DeprecatedTrait.class)) {
            builder.putExtension("deprecated", (ToNode)Node.from((boolean)true));
        }
        if ((enabled || config.getBooleanMemberOrDefault("openapi.use.formats")) && !builder.getFormat().isPresent()) {
            if (shape.isIntegerShape()) {
                builder.format("int32");
            } else if (shape.isLongShape()) {
                builder.format("int64");
            } else if (shape.isFloatShape()) {
                builder.format("float");
            } else if (shape.isDoubleShape()) {
                builder.format("double");
            } else {
                if (shape.isBlobShape()) {
                    return builder.format(config.getStringMemberOrDefault("openapi.defaultBlobFormat", DEFAULT_BLOB_FORMAT));
                }
                if (shape.hasTrait(SensitiveTrait.class)) {
                    builder.format("password");
                }
            }
        }
        if (config.getBooleanMemberOrDefault("openapi.use.xml")) {
            LOGGER.warning("openapi.use.xml is not yet implemented");
        }
        if (enabled) {
            UNSUPPORTED_KEYWORD_DIRECTIVES.forEach(arg_0 -> ((Schema.Builder)builder).disableProperty(arg_0));
        }
        return builder;
    }
}

