/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.mappers;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.Pair;

public class InlineReferencesToPrimitiveTypes
implements OpenApiMapper {
    @Override
    public byte getOrder() {
        return 110;
    }

    @Override
    public ObjectNode updateNode(Context context, OpenApi openapi, ObjectNode node) {
        Set removedThisRound;
        if (context.getConfig().getBooleanMemberOrDefault("openapi.disablePrimitiveInlining")) {
            return node;
        }
        ObjectNode denormalized = node;
        HashSet removed = new HashSet();
        do {
            Pair<ObjectNode, Set<String>> resultPair = InlineReferencesToPrimitiveTypes.denormalize(denormalized);
            denormalized = (ObjectNode)resultPair.getLeft();
            removedThisRound = (Set)resultPair.getRight();
            removed.addAll(removedThisRound);
        } while (!removedThisRound.isEmpty());
        ObjectNode updatedComponents = denormalized.getObjectMember("components").orElseGet(Node::objectNode);
        ObjectNode updatedSchemas = (ObjectNode)updatedComponents.getObjectMember("schemas").orElseGet(Node::objectNode).getMembers().entrySet().stream().filter(entry -> !removed.contains(((StringNode)entry.getKey()).getValue())).collect(ObjectNode.collect(Map.Entry::getKey, Map.Entry::getValue));
        return denormalized.withMember("components", (ToNode)updatedComponents.withMember("schemas", (ToNode)updatedSchemas));
    }

    private static Pair<ObjectNode, Set<String>> denormalize(ObjectNode model) {
        ObjectNode schemas = model.getObjectMember("components").orElseGet(Node::objectNode).getObjectMember("schemas").orElseGet(Node::objectNode);
        PrimitiveReferenceInliner inliner = new PrimitiveReferenceInliner(schemas);
        ObjectNode result = ((Node)model.accept((NodeVisitor)inliner)).expectObjectNode();
        return Pair.of((Object)result, (Object)inliner.removed);
    }

    private static final class PrimitiveReferenceInliner
    extends NodeVisitor.Default<Node> {
        private final ObjectNode schemas;
        private Set<String> removed = new HashSet<String>();

        private PrimitiveReferenceInliner(ObjectNode schemas) {
            this.schemas = schemas;
        }

        public ArrayNode arrayNode(ArrayNode node) {
            return (ArrayNode)node.getElements().stream().map(elementNode -> (Node)elementNode.accept((NodeVisitor)this)).collect(ArrayNode.collect());
        }

        protected Node getDefault(Node node) {
            return node;
        }

        public ObjectNode objectNode(ObjectNode node) {
            String refKey;
            ObjectNode target;
            Optional ref = node.getStringMember("$ref");
            if (ref.isPresent() && PrimitiveReferenceInliner.shouldInline(target = (ObjectNode)this.schemas.getObjectMember(refKey = ((StringNode)ref.get()).getValue().replace("#/components/schemas/", "")).orElse(null))) {
                this.removed.add(refKey);
                return target;
            }
            return (ObjectNode)node.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()), (Object)((Node)((Node)entry.getValue()).accept((NodeVisitor)this)))).collect(ObjectNode.collect(Pair::getLeft, Pair::getRight));
        }

        private static boolean shouldInline(ObjectNode target) {
            String type;
            if (target == null) {
                return false;
            }
            switch (type = target.getStringMemberOrDefault("type", "")) {
                case "integer": 
                case "number": 
                case "boolean": 
                case "string": {
                    return true;
                }
                case "array": {
                    return target.getObjectMember("items").filter(PrimitiveReferenceInliner::shouldInline).isPresent();
                }
                case "object": {
                    return !target.getMember("properties").isPresent() && target.getObjectMember("additionalProperties").filter(PrimitiveReferenceInliner::shouldInline).isPresent();
                }
            }
            return false;
        }
    }
}

