/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitTargetValidator
extends AbstractValidator {
    private static final Pattern SANITIZE = Pattern.compile("\n\\s*");

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Collection<SelectorTest> tests = this.createTests(model);
        for (SelectorTest test : tests) {
            Set<Shape> matches = test.selector.select(model);
            test.appliedTo.removeAll(matches);
            for (Shape shape : test.appliedTo) {
                String sanitized = SANITIZE.matcher(test.selector.toString()).replaceAll(" ");
                events.add(this.error(shape, shape.findTrait(test.trait).get(), String.format("Trait `%s` cannot be applied to `%s`. This trait may only be applied to shapes that match the following selector: %s", Trait.getIdiomaticTraitName(test.trait.toShapeId()), shape.getId(), sanitized)));
            }
        }
        return events;
    }

    private Collection<SelectorTest> createTests(Model model) {
        ArrayList<SelectorTest> tests = new ArrayList<SelectorTest>(model.getAppliedTraits().size());
        for (ShapeId traitId : model.getAppliedTraits()) {
            HashSet<Shape> shapes = new HashSet<Shape>(model.getShapesWithTrait(traitId));
            model.getTraitDefinition(traitId).ifPresent(definition -> tests.add(new SelectorTest(traitId, definition.getSelector(), shapes)));
        }
        return tests;
    }

    private static final class SelectorTest {
        final ShapeId trait;
        final Selector selector;
        final Set<Shape> appliedTo;

        SelectorTest(ShapeId trait, Selector selector, Set<Shape> appliedTo) {
            this.trait = trait;
            this.selector = selector;
            this.appliedTo = appliedTo;
        }
    }
}

