/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorService;

public abstract class AbstractValidator
implements Validator {
    private final String defaultName = ValidatorService.determineValidatorName(this.getClass());

    public String getName() {
        return this.defaultName;
    }

    protected final ValidationEvent error(Shape shape, String message) {
        return this.createEvent(Severity.ERROR, shape, shape.getSourceLocation(), message);
    }

    protected final ValidationEvent error(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.ERROR, shape, location, message);
    }

    protected final ValidationEvent danger(Shape shape, String message) {
        return this.createEvent(Severity.DANGER, shape, shape.getSourceLocation(), message);
    }

    protected final ValidationEvent danger(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.DANGER, shape, location, message);
    }

    protected final ValidationEvent warning(Shape shape, String message) {
        return this.createEvent(Severity.WARNING, shape, shape.getSourceLocation(), message);
    }

    protected final ValidationEvent warning(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.WARNING, shape, location, message);
    }

    protected final ValidationEvent note(Shape shape, String message) {
        return this.createEvent(Severity.NOTE, shape, shape.getSourceLocation(), message);
    }

    protected final ValidationEvent note(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.NOTE, shape, location, message);
    }

    private ValidationEvent createEvent(Severity severity, Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(ValidationEvent.builder().severity(severity).message(message).shapeId(shape.getId()).sourceLocation(location.getSourceLocation()));
    }

    private ValidationEvent createEvent(ValidationEvent.Builder builder) {
        return builder.id(this.getName()).build();
    }
}

