/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AnnotationTrait;

public final class StreamingTrait
extends AnnotationTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#streaming");

    public StreamingTrait(ObjectNode node) {
        super(ID, node);
    }

    public StreamingTrait() {
        this(Node.objectNode());
    }

    public static boolean isEventStream(Shape shape) {
        return shape.isUnionShape() && shape.hasTrait(ID);
    }

    public static boolean isEventStream(Model model, MemberShape member) {
        return StreamingTrait.isEventStream(model.expectShape(member.getTarget()));
    }

    public static final class Provider
    extends AnnotationTrait.Provider<StreamingTrait> {
        public Provider() {
            super(ID, StreamingTrait::new);
        }
    }
}

