/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Model
implements ToSmithyBuilder<Model> {
    public static final String MODEL_VERSION = "1.0";
    private final Map<String, Node> metadata;
    private final Map<ShapeId, Shape> shapeMap;
    private final Map<Class<? extends Shape>, Set<? extends Shape>> cachedTypes = new ConcurrentHashMap<Class<? extends Shape>, Set<? extends Shape>>();
    private final Map<Class<? extends KnowledgeIndex>, KnowledgeIndex> blackboard = new ConcurrentHashMap<Class<? extends KnowledgeIndex>, KnowledgeIndex>();
    private volatile TraitCache traitCache;
    private int hash;

    private Model(Builder builder) {
        this.shapeMap = MapUtils.copyOf((Map)builder.shapeMap);
        this.metadata = builder.metadata.isEmpty() ? MapUtils.of() : MapUtils.copyOf((Map)builder.metadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelAssembler assembler() {
        return new ModelAssembler();
    }

    public static ModelAssembler assembler(ClassLoader classLoader) {
        return new ModelAssembler().traitFactory(TraitFactory.createServiceFactory(classLoader)).validatorFactory(ValidatorFactory.createServiceFactory(classLoader));
    }

    public Optional<Node> getMetadataProperty(String name) {
        return Optional.ofNullable(this.metadata.get(name));
    }

    public Map<String, Node> getMetadata() {
        return this.metadata;
    }

    public Optional<TraitDefinition> getTraitDefinition(ToShapeId traitId) {
        return this.getShape(traitId.toShapeId()).flatMap(shape -> shape.getTrait(TraitDefinition.class));
    }

    public Set<Shape> getShapesWithTrait(ToShapeId trait) {
        Map mappings = this.getTraitCache().traitIdsToShapes;
        return Collections.unmodifiableSet(mappings.getOrDefault(trait.toShapeId(), Collections.emptySet()));
    }

    private TraitCache getTraitCache() {
        TraitCache cache = this.traitCache;
        if (cache == null) {
            this.traitCache = cache = new TraitCache(this.shapeMap.values());
        }
        return cache;
    }

    public Set<ShapeId> getShapeIds() {
        return this.shapeMap.keySet();
    }

    public Set<Shape> getShapesWithTrait(Class<? extends Trait> trait) {
        Map mappings = this.getTraitCache().traitsToShapes;
        return Collections.unmodifiableSet(mappings.getOrDefault(trait, Collections.emptySet()));
    }

    public Set<ShapeId> getAppliedTraits() {
        return Collections.unmodifiableSet(this.getTraitCache().traitIdsToShapes.keySet());
    }

    public boolean isTraitApplied(Class<? extends Trait> trait) {
        return !this.getShapesWithTrait(trait).isEmpty();
    }

    public Optional<Shape> getShape(ShapeId id) {
        return Optional.ofNullable(this.shapeMap.get(id));
    }

    public Shape expectShape(ShapeId id) {
        return this.getShape(id).orElseThrow(() -> new ExpectationNotMetException("Shape not found in model: " + id, SourceLocation.NONE));
    }

    public <T extends Shape> T expectShape(ShapeId id, Class<T> type) {
        Shape shape = this.expectShape(id);
        if (type.isInstance(shape)) {
            return (T)shape;
        }
        throw new ExpectationNotMetException(String.format("Expected shape `%s` to be an instance of `%s`, but found `%s`", new Object[]{id, type.getSimpleName(), shape.getType()}), shape);
    }

    public Stream<Shape> shapes() {
        return this.shapeMap.values().stream();
    }

    public <T extends Shape> Stream<T> shapes(Class<T> shapeType) {
        return this.toSet(shapeType).stream();
    }

    private <T extends Shape> Set<T> toSet(Class<T> shapeType) {
        return this.cachedTypes.computeIfAbsent(shapeType, t -> {
            HashSet<Shape> result = new HashSet<Shape>();
            for (Shape shape : this.shapeMap.values()) {
                if (shape.getClass() != shapeType) continue;
                result.add(shape);
            }
            return Collections.unmodifiableSet(result);
        });
    }

    public Set<Shape> toSet() {
        return new AbstractSet<Shape>(){

            @Override
            public int size() {
                return Model.this.shapeMap.size();
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof Shape && Model.this.shapeMap.containsKey(((Shape)o).getId());
            }

            @Override
            public Iterator<Shape> iterator() {
                return Model.this.shapeMap.values().iterator();
            }
        };
    }

    public boolean equals(Object other) {
        if (!(other instanceof Model)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Model otherModel = (Model)other;
        return this.getMetadata().equals(otherModel.getMetadata()) && this.shapeMap.equals(otherModel.shapeMap);
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = Objects.hash(this.getMetadata(), this.shapeMap.keySet());
        }
        return result;
    }

    public Builder toBuilder() {
        return Model.builder().metadata(this.getMetadata()).addShapes(this);
    }

    @Deprecated
    public <T extends KnowledgeIndex> T getKnowledge(Class<T> type) {
        return (T)this.getKnowledge(type, m -> {
            try {
                return (KnowledgeIndex)type.getConstructor(Model.class).newInstance(this);
            }
            catch (NoSuchMethodException e) {
                String message = String.format("KnowledgeIndex for type `%s` does not expose a public constructor that accepts a Model", type);
                throw new RuntimeException(message, e);
            }
            catch (ReflectiveOperationException e) {
                String message = String.format("Unable to create a KnowledgeIndex for type `%s`: %s", type, e.getMessage());
                throw new RuntimeException(message, e);
            }
        });
    }

    public <T extends KnowledgeIndex> T getKnowledge(Class<T> type, Function<Model, T> constructor) {
        KnowledgeIndex value = this.blackboard.get(type);
        if (value == null) {
            value = (KnowledgeIndex)constructor.apply(this);
            this.blackboard.put(type, value);
        }
        return (T)value;
    }

    private static final class TraitCache {
        private final Map<ShapeId, Set<Shape>> traitIdsToShapes = new HashMap<ShapeId, Set<Shape>>();
        private final Map<Class<? extends Trait>, Set<Shape>> traitsToShapes = new HashMap<Class<? extends Trait>, Set<Shape>>();

        TraitCache(Collection<Shape> shapes) {
            for (Shape shape : shapes) {
                for (Trait trait : shape.getAllTraits().values()) {
                    this.traitIdsToShapes.computeIfAbsent(trait.toShapeId(), id -> new HashSet()).add(shape);
                    this.traitsToShapes.computeIfAbsent(trait.getClass(), id -> new HashSet()).add(shape);
                }
            }
        }
    }

    public static final class Builder
    implements SmithyBuilder<Model> {
        private final Map<String, Node> metadata = new HashMap<String, Node>();
        private final Map<ShapeId, Shape> shapeMap = new HashMap<ShapeId, Shape>();

        private Builder() {
        }

        public Builder metadata(Map<String, Node> metadata) {
            this.clearMetadata();
            this.metadata.putAll(metadata);
            return this;
        }

        public Builder putMetadataProperty(String key, Node value) {
            this.metadata.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }

        public Builder clearMetadata() {
            this.metadata.clear();
            return this;
        }

        public Builder addShape(Shape shape) {
            if (!shape.isMemberShape()) {
                this.shapeMap.put(shape.getId(), shape);
                for (MemberShape memberShape : shape.members()) {
                    this.shapeMap.put(memberShape.getId(), memberShape);
                }
            }
            return this;
        }

        public Builder addShapes(Model model) {
            this.shapeMap.putAll(model.shapeMap);
            return this;
        }

        public <S extends Shape> Builder addShapes(Collection<S> shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder addShapes(Shape ... shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder removeShape(ShapeId shapeId) {
            if (this.shapeMap.containsKey(shapeId)) {
                Shape previous = this.shapeMap.get(shapeId);
                this.shapeMap.remove(shapeId);
                for (MemberShape memberShape : previous.members()) {
                    this.shapeMap.remove(memberShape.getId());
                }
            }
            return this;
        }

        public Model build() {
            return new Model(this);
        }
    }
}

