/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Objects;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;

public final class NeighborProviderIndex
implements KnowledgeIndex {
    private final NeighborProvider provider;
    private final WeakReference<Model> model;
    private volatile NeighborProvider reversed;
    private volatile NeighborProvider providerWithTraits;
    private volatile NeighborProvider reversedWithTraits;

    public NeighborProviderIndex(Model model) {
        this.provider = NeighborProvider.precomputed(model);
        this.model = new WeakReference<Model>(model);
    }

    public static NeighborProviderIndex of(Model model) {
        return model.getKnowledge(NeighborProviderIndex.class, NeighborProviderIndex::new);
    }

    public NeighborProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeighborProvider getProviderWithTraitRelationships() {
        NeighborProvider result = this.providerWithTraits;
        if (result == null) {
            Model model = this.getOrThrowModel();
            NeighborProviderIndex neighborProviderIndex = this;
            synchronized (neighborProviderIndex) {
                result = this.providerWithTraits;
                if (result == null) {
                    this.providerWithTraits = result = NeighborProvider.cached(NeighborProvider.withTraitRelationships(model, this.provider));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeighborProvider getReverseProvider() {
        NeighborProvider result = this.reversed;
        if (result == null) {
            Model model = this.getOrThrowModel();
            NeighborProviderIndex neighborProviderIndex = this;
            synchronized (neighborProviderIndex) {
                result = this.reversed;
                if (result == null) {
                    this.reversed = result = NeighborProvider.reverse(model, this.provider);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeighborProvider getReverseProviderWithTraitRelationships() {
        NeighborProvider result = this.reversedWithTraits;
        if (result == null) {
            NeighborProviderIndex neighborProviderIndex = this;
            synchronized (neighborProviderIndex) {
                result = this.reversedWithTraits;
                if (result == null) {
                    NeighborProvider withTraits = this.getProviderWithTraitRelationships();
                    this.reversedWithTraits = result = NeighborProvider.reverse(this.getOrThrowModel(), withTraits);
                }
            }
        }
        return result;
    }

    private Model getOrThrowModel() {
        return (Model)Objects.requireNonNull(this.model.get(), "Model was destroyed before using this knowledge index");
    }
}

