/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class BottomUpIndex
implements KnowledgeIndex {
    private static final Selector SELECTOR = Selector.parse(":is(resource, operation)");
    private final Map<ShapeId, Map<ShapeId, List<EntityShape>>> parentBindings = new HashMap<ShapeId, Map<ShapeId, List<EntityShape>>>();

    public BottomUpIndex(Model model) {
        PathFinder pathFinder = PathFinder.create(model);
        model.shapes(ServiceShape.class).forEach(service -> {
            HashMap serviceBindings = new HashMap();
            this.parentBindings.put(service.getId(), serviceBindings);
            for (PathFinder.Path path : pathFinder.search((ToShapeId)service, SELECTOR)) {
                ArrayList<EntityShape> shapes = new ArrayList<EntityShape>();
                for (int i = path.size() - 1; i >= 0; --i) {
                    Relationship rel = path.get(i);
                    if (!(rel.getShape() instanceof EntityShape)) continue;
                    shapes.add((EntityShape)rel.getShape());
                }
                serviceBindings.put(path.getEndShape().getId(), shapes);
            }
        });
    }

    public static BottomUpIndex of(Model model) {
        return model.getKnowledge(BottomUpIndex.class, BottomUpIndex::new);
    }

    public List<EntityShape> getAllParents(ToShapeId service, ToShapeId operationOrResource) {
        Map serviceBindings = this.parentBindings.getOrDefault(service.toShapeId(), Collections.emptyMap());
        List entities = (List)serviceBindings.get(operationOrResource.toShapeId());
        return entities == null ? Collections.emptyList() : Collections.unmodifiableList(entities);
    }

    public Optional<EntityShape> getEntityBinding(ToShapeId service, ToShapeId operationOrResource) {
        List<EntityShape> entities = this.getAllParents(service, operationOrResource);
        return entities.isEmpty() ? Optional.empty() : Optional.of(entities.get(0));
    }

    public Optional<ResourceShape> getResourceBinding(ToShapeId service, ToShapeId operationOrResource) {
        return this.getEntityBinding(service, operationOrResource).filter(ResourceShape.class::isInstance).map(ResourceShape.class::cast);
    }
}

