/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;

public final class HttpLabelTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : model.getShapesWithTrait(HttpTrait.class)) {
            shape.asOperationShape().ifPresent(operation -> events.addAll(this.validateStructure(model, (OperationShape)operation, operation.expectTrait(HttpTrait.class))));
        }
        return events;
    }

    private List<ValidationEvent> validateStructure(Model model, OperationShape operation, HttpTrait http) {
        if (!operation.getInput().isPresent() && !http.getUri().getLabels().isEmpty()) {
            return ListUtils.of((Object)this.error(operation, http, String.format("`http` trait uri contains labels (%s), but operation has no input.", ValidationUtils.tickedList(http.getUri().getLabels().stream().map(SmithyPattern.Segment::getContent).collect(Collectors.toSet())))));
        }
        return operation.getInput().flatMap(model::getShape).flatMap(Shape::asStructureShape).map(input -> this.validateBindings(model, operation, http, (StructureShape)input)).orElse(ListUtils.of());
    }

    private List<ValidationEvent> validateBindings(Model model, OperationShape operation, HttpTrait http, StructureShape input) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Set labels = http.getUri().getLabels().stream().map(SmithyPattern.Segment::getContent).collect(Collectors.toSet());
        input.getAllMembers().values().stream().flatMap(member -> Trait.flatMapStream(member, HttpLabelTrait.class)).forEach(pair -> {
            MemberShape member = (MemberShape)pair.getLeft();
            HttpLabelTrait trait = (HttpLabelTrait)pair.getRight();
            labels.remove(member.getMemberName());
            if (member.isOptional()) {
                events.add(this.error(member, trait, "Members with the `httpLabel` trait must be required."));
            }
            if (!http.getUri().getLabel(member.getMemberName()).isPresent()) {
                events.add(this.error(member, trait, String.format("This `%s` structure member is marked with the `httpLabel` trait, but no corresponding `http` URI label could be found when used as the input of the `%s` operation.", member.getMemberName(), operation.getId())));
            } else if (http.getUri().getLabel(member.getMemberName()).get().isGreedyLabel()) {
                model.getShape(member.getTarget()).ifPresent(target -> {
                    if (!target.isStringShape()) {
                        events.add(this.error(member, trait, String.format("The `%s` structure member corresponds to a greedy label when used as the input of the `%s` operation. This member targets %s, but greedy labels must target string shapes.", member.getMemberName(), operation.getId(), target)));
                    }
                });
            }
        });
        if (!labels.isEmpty()) {
            events.add(this.error(input, String.format("This structure is used as the input for the `%s` operation, but the following URI labels found in the operation's `http` trait do not have a corresponding member marked with the `httpLabel` trait: %s", operation.getId(), ValidationUtils.tickedList(labels))));
        }
        return events;
    }
}

