/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.selector.AttributeValueImpl;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

public interface AttributeValue {
    public String toString();

    default public String toMessageString() {
        return this.toString();
    }

    public AttributeValue getProperty(String var1);

    default public AttributeValue getPath(List<String> path) {
        String segment;
        if (!this.isPresent() || path.isEmpty()) {
            return this;
        }
        AttributeValue current = this;
        Iterator<String> iterator = path.iterator();
        while (iterator.hasNext() && (current = current.getProperty(segment = iterator.next())).isPresent()) {
        }
        return current;
    }

    default public boolean isPresent() {
        return true;
    }

    default public Collection<? extends AttributeValue> getFlattenedValues() {
        return Collections.singleton(this);
    }

    public static AttributeValue shape(Shape shape, Map<String, Set<Shape>> vars) {
        return new AttributeValueImpl.ShapeValue(shape, vars);
    }

    public static AttributeValue id(ShapeId id) {
        return new AttributeValueImpl.Id(id);
    }

    public static AttributeValue service(ServiceShape service) {
        return new AttributeValueImpl.Service(service);
    }

    public static AttributeValue emptyValue() {
        return AttributeValueImpl.EMPTY;
    }

    public static AttributeValue literal(Object literal) {
        return new AttributeValueImpl.Literal(literal);
    }

    public static AttributeValue node(Node node) {
        return new AttributeValueImpl.NodeValue(node);
    }

    public static AttributeValue projection(Collection<AttributeValue> values) {
        return new AttributeValueImpl.Projection(values);
    }
}

