/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class AddedOperationError
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(OperationShape.class).flatMap(change -> this.createErrorViolations((ChangedShape<OperationShape>)change, differences.getNewModel()).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> createErrorViolations(ChangedShape<OperationShape> change, Model newModel) {
        if (change.getOldShape().getErrors().equals(change.getNewShape().getErrors())) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ShapeId error : change.getNewShape().getErrors()) {
            SourceLocation errorSource = newModel.expectShape(error).getSourceLocation();
            if (change.getOldShape().getErrors().contains(error)) continue;
            events.add(ValidationEvent.builder().id(this.getEventId() + "." + error.getName()).severity(Severity.WARNING).message(String.format("The `%s` error was added to the `%s` operation. This is backward-compatible if the error is only encountered as a result of a change in behavior of the client (for example, the client sends a new parameter to an operation).", error, change.getShapeId())).shape((Shape)change.getNewShape()).sourceLocation((FromSourceLocation)errorSource).build());
        }
        return events;
    }
}

