/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

public final class ChangedMemberTarget
extends AbstractDiffEvaluator {
    private static final Set<ShapeId> SIGNIFICANT_CODEGEN_TRAITS = SetUtils.of((Object)EnumTrait.ID);

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(MemberShape.class).filter(change -> !((MemberShape)change.getOldShape()).getTarget().equals((Object)((MemberShape)change.getNewShape()).getTarget())).map(change -> this.createChangeEvent(differences, (ChangedShape<MemberShape>)change)).collect(Collectors.toList());
    }

    private ValidationEvent createChangeEvent(Differences differences, ChangedShape<MemberShape> change) {
        Shape newTarget;
        Shape oldTarget = this.getShapeTarget(differences.getOldModel(), change.getOldShape().getTarget());
        List<String> issues = ChangedMemberTarget.areShapesCompatible(oldTarget, newTarget = this.getShapeTarget(differences.getNewModel(), change.getNewShape().getTarget()));
        Severity severity = issues.isEmpty() ? Severity.WARNING : Severity.ERROR;
        String message = ChangedMemberTarget.createSimpleMessage(change, oldTarget, newTarget);
        message = severity == Severity.WARNING ? message + "This was determined backward compatible." : message + String.join((CharSequence)". ", issues) + ".";
        return ValidationEvent.builder().severity(severity).id(this.getEventId()).shape((Shape)change.getNewShape()).message(message).build();
    }

    private Shape getShapeTarget(Model model, ShapeId id) {
        return model.getShape(id).orElse(null);
    }

    private static List<String> areShapesCompatible(Shape oldShape, Shape newShape) {
        if (oldShape == null || newShape == null) {
            return ListUtils.of();
        }
        if (oldShape.getType() != newShape.getType()) {
            return ListUtils.of((Object)String.format("The type of the targeted shape changed from %s to %s", oldShape.getType(), newShape.getType()));
        }
        if (!(oldShape instanceof SimpleShape || oldShape instanceof CollectionShape || oldShape instanceof MapShape)) {
            return ListUtils.of((Object)String.format("The name of a %s is significant", oldShape.getType()));
        }
        ArrayList<String> results = new ArrayList<String>();
        for (ShapeId significantCodegenTrait : SIGNIFICANT_CODEGEN_TRAITS) {
            if (!oldShape.hasTrait(significantCodegenTrait)) continue;
            results.add(String.format("The `%s` trait was found on the target, so the name of the targeted shape matters for codegen", significantCodegenTrait));
        }
        if (!oldShape.getAllTraits().equals(newShape.getAllTraits())) {
            results.add(ChangedMemberTarget.createTraitDiffMessage(oldShape, newShape));
        }
        if (oldShape instanceof CollectionShape) {
            ChangedMemberTarget.evaluateMember(oldShape.getType(), results, ((CollectionShape)oldShape).getMember(), ((CollectionShape)newShape).getMember());
        } else if (oldShape instanceof MapShape) {
            MapShape oldMapShape = (MapShape)oldShape;
            MapShape newMapShape = (MapShape)newShape;
            ChangedMemberTarget.evaluateMember(oldShape.getType(), results, oldMapShape.getKey(), newMapShape.getKey());
            ChangedMemberTarget.evaluateMember(oldShape.getType(), results, oldMapShape.getValue(), newMapShape.getValue());
        }
        return results;
    }

    private static void evaluateMember(ShapeType oldShapeType, List<String> results, MemberShape oldMember, MemberShape newMember) {
        String memberSlug;
        String string = memberSlug = oldShapeType == ShapeType.MAP ? oldMember.getMemberName() + " " : "";
        if (!oldMember.getTarget().equals((Object)newMember.getTarget())) {
            results.add(String.format("Both the old and new shapes are a %s, but the old shape %stargeted `%s` while the new shape targets `%s`", oldShapeType, memberSlug, oldMember.getTarget(), newMember.getTarget()));
        } else if (!oldMember.getAllTraits().equals(newMember.getAllTraits())) {
            results.add(String.format("Both the old and new shapes are a %s, but their %smembers have differing traits. %s", oldShapeType, memberSlug, ChangedMemberTarget.createTraitDiffMessage((Shape)oldMember, (Shape)newMember)));
        }
    }

    private static String createSimpleMessage(ChangedShape<MemberShape> change, Shape oldTarget, Shape newTarget) {
        return String.format("The shape targeted by the member `%s` changed from `%s` (%s) to `%s` (%s). ", change.getShapeId(), change.getOldShape().getTarget(), oldTarget.getType(), change.getNewShape().getTarget(), newTarget.getType());
    }

    private static String createTraitDiffMessage(Shape oldShape, Shape newShape) {
        Set addedTraits;
        StringJoiner joiner = new StringJoiner(". ");
        ChangedShape<Shape> targetChange = new ChangedShape<Shape>(oldShape, newShape);
        Set removedTraits = targetChange.removedTraits().map(Trait::toShapeId).collect(Collectors.toCollection(TreeSet::new));
        if (!removedTraits.isEmpty()) {
            joiner.add("The targeted shape no longer has the following traits: " + removedTraits);
        }
        if (!(addedTraits = (Set)targetChange.addedTraits().map(Trait::toShapeId).collect(Collectors.toCollection(TreeSet::new))).isEmpty()) {
            joiner.add("The newly targeted shape now has the following additional traits: " + addedTraits);
        }
        TreeSet<ShapeId> changedTraits = new TreeSet<ShapeId>(targetChange.getTraitDifferences().keySet());
        changedTraits.removeAll(addedTraits);
        changedTraits.removeAll(removedTraits);
        if (!changedTraits.isEmpty()) {
            joiner.add("The newly targeted shape has traits that differ from the previous shape: " + changedTraits);
        }
        return joiner.toString();
    }
}

