/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import software.amazon.smithy.diff.DiffEvaluator;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public abstract class AbstractDiffEvaluator
implements DiffEvaluator {
    protected String getEventId() {
        return this.getClass().getSimpleName();
    }

    protected final ValidationEvent error(Shape shape, String message) {
        return this.createEvent(Severity.ERROR, shape, (FromSourceLocation)shape.getSourceLocation(), message);
    }

    protected final ValidationEvent error(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.ERROR, shape, location, message);
    }

    protected final ValidationEvent danger(Shape shape, String message) {
        return this.createEvent(Severity.DANGER, shape, (FromSourceLocation)shape.getSourceLocation(), message);
    }

    protected final ValidationEvent danger(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.DANGER, shape, location, message);
    }

    protected final ValidationEvent warning(Shape shape, String message) {
        return this.createEvent(Severity.WARNING, shape, (FromSourceLocation)shape.getSourceLocation(), message);
    }

    protected final ValidationEvent warning(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.WARNING, shape, location, message);
    }

    protected final ValidationEvent note(Shape shape, String message) {
        return this.createEvent(Severity.NOTE, shape, (FromSourceLocation)shape.getSourceLocation(), message);
    }

    protected final ValidationEvent note(Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(Severity.NOTE, shape, location, message);
    }

    private ValidationEvent createEvent(Severity severity, Shape shape, FromSourceLocation location, String message) {
        return this.createEvent(ValidationEvent.builder().severity(severity).message(message).shapeId((ToShapeId)shape.getId()).sourceLocation((FromSourceLocation)location.getSourceLocation()));
    }

    private ValidationEvent createEvent(ValidationEvent.Builder builder) {
        return builder.id(this.getEventId()).build();
    }
}

