/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.transport.http.RFC9457;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import software.amazon.smithy.cli.shaded.apache.http.Header;
import software.amazon.smithy.cli.shaded.apache.http.client.methods.CloseableHttpResponse;
import software.amazon.smithy.cli.shaded.apache.http.util.EntityUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.transport.http.RFC9457.HttpRFC9457Exception;
import software.amazon.smithy.cli.shaded.eclipse.aether.transport.http.RFC9457.RFC9457Parser;
import software.amazon.smithy.cli.shaded.eclipse.aether.transport.http.RFC9457.RFC9457Payload;

public class RFC9457Reporter {
    public static final RFC9457Reporter INSTANCE = new RFC9457Reporter();

    public boolean isRFC9457Message(CloseableHttpResponse response) {
        Header[] headers = response.getHeaders("Content-Type");
        if (headers.length > 0) {
            String contentType = headers[0].getValue();
            return this.hasRFC9457ContentType(contentType);
        }
        return false;
    }

    public void generateException(CloseableHttpResponse response) throws HttpRFC9457Exception {
        String body;
        int statusCode = this.getStatusCode(response);
        String reasonPhrase = this.getReasonPhrase(response);
        try {
            body = this.getBody(response);
        }
        catch (IOException ignore) {
            throw new HttpRFC9457Exception(statusCode, reasonPhrase, RFC9457Payload.INSTANCE);
        }
        if (body != null && !body.isEmpty()) {
            RFC9457Payload rfc9457Payload = RFC9457Parser.parse(body);
            throw new HttpRFC9457Exception(statusCode, reasonPhrase, rfc9457Payload);
        }
        throw new HttpRFC9457Exception(statusCode, reasonPhrase, RFC9457Payload.INSTANCE);
    }

    private String getBody(CloseableHttpResponse response) throws IOException {
        return EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
    }

    private int getStatusCode(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private String getReasonPhrase(CloseableHttpResponse response) {
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        if (reasonPhrase == null || reasonPhrase.isEmpty()) {
            return "";
        }
        int statusCode = this.getStatusCode(response);
        return reasonPhrase + " (" + statusCode + ")";
    }

    private boolean hasRFC9457ContentType(String contentType) {
        return "application/problem+json".equals(contentType);
    }
}

