/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.space;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Mediator;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.BeanLocator;
import software.amazon.smithy.cli.shaded.google.inject.Binder;
import software.amazon.smithy.cli.shaded.google.inject.Key;
import software.amazon.smithy.cli.shaded.google.inject.TypeLiteral;
import software.amazon.smithy.cli.shaded.google.inject.matcher.AbstractMatcher;
import software.amazon.smithy.cli.shaded.google.inject.spi.InjectionListener;
import software.amazon.smithy.cli.shaded.google.inject.spi.TypeEncounter;
import software.amazon.smithy.cli.shaded.google.inject.spi.TypeListener;
import software.amazon.smithy.cli.shaded.javax.inject.Provider;

final class MediationListener
extends AbstractMatcher<TypeLiteral<?>>
implements TypeListener,
InjectionListener<Object> {
    private final List<Mediation<?, ?, ?>> mediation = new ArrayList();
    private final Provider<BeanLocator> locator;

    public MediationListener(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public void mediate(Key key, Mediator mediator, Class watcherType) {
        this.mediation.add(new Mediation(key, mediator, watcherType));
    }

    public boolean matches(TypeLiteral<?> type) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isAssignableFrom(type.getRawType())) continue;
            return true;
        }
        return false;
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        encounter.register((InjectionListener)this);
    }

    public void afterInjection(Object watcher) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isInstance(watcher)) continue;
            this.locator.get().watch(m.watchedKey, m.mediator, watcher);
        }
    }

    private static final class Mediation<Q extends Annotation, T, W> {
        final Key<T> watchedKey;
        final Mediator<Q, T, W> mediator;
        final Class<W> watcherType;

        Mediation(Key<T> watchedKey, Mediator<Q, T, W> mediator, Class<W> watcherType) {
            this.watchedKey = watchedKey;
            this.mediator = mediator;
            this.watcherType = watcherType;
        }
    }
}

