/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.model.plugin;

import software.amazon.smithy.cli.shaded.apache.maven.model.Model;
import software.amazon.smithy.cli.shaded.apache.maven.model.ReportPlugin;
import software.amazon.smithy.cli.shaded.apache.maven.model.ReportSet;
import software.amazon.smithy.cli.shaded.apache.maven.model.Reporting;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelBuildingRequest;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProblemCollector;
import software.amazon.smithy.cli.shaded.apache.maven.model.plugin.ReportConfigurationExpander;
import software.amazon.smithy.cli.shaded.codehaus.plexus.util.xml.Xpp3Dom;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class DefaultReportConfigurationExpander
implements ReportConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Reporting reporting = model.getReporting();
        if (reporting != null) {
            for (ReportPlugin reportPlugin : reporting.getPlugins()) {
                Xpp3Dom parentDom = (Xpp3Dom)reportPlugin.getConfiguration();
                if (parentDom == null) continue;
                for (ReportSet execution : reportPlugin.getReportSets()) {
                    Xpp3Dom childDom = (Xpp3Dom)execution.getConfiguration();
                    childDom = Xpp3Dom.mergeXpp3Dom(childDom, new Xpp3Dom(parentDom));
                    execution.setConfiguration(childDom);
                }
            }
        }
    }
}

