/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.repository.internal;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.cli.shaded.apache.maven.artifact.ArtifactUtils;
import software.amazon.smithy.cli.shaded.apache.maven.artifact.repository.metadata.Versioning;
import software.amazon.smithy.cli.shaded.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositoryEvent;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.RequestTrace;
import software.amazon.smithy.cli.shaded.eclipse.aether.SyncContext;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.MetadataResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RepositoryEventDispatcher;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.VersionRangeResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.DefaultMetadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.Metadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.ArtifactRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.WorkspaceReader;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.MetadataRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.MetadataResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.synccontext.SyncContextFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.version.GenericVersionScheme;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.InvalidVersionSpecificationException;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.Version;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.VersionConstraint;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.VersionRange;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class DefaultVersionRangeResolver
implements VersionRangeResolver,
Service {
    public static final String MAVEN_VERSION_RANGE_RESOLUTION_NATURE = "maven.versionRangeResolutionNature";
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private MetadataResolver metadataResolver;
    private SyncContextFactory syncContextFactory;
    private RepositoryEventDispatcher repositoryEventDispatcher;

    @Deprecated
    public DefaultVersionRangeResolver() {
    }

    @Inject
    public DefaultVersionRangeResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher) {
        this.setMetadataResolver(metadataResolver);
        this.setSyncContextFactory(syncContextFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    @Deprecated
    public void initService(ServiceLocator locator) {
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultVersionRangeResolver setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadataResolver cannot be null");
        return this;
    }

    public DefaultVersionRangeResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "syncContextFactory cannot be null");
        return this;
    }

    public DefaultVersionRangeResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        VersionConstraint versionConstraint;
        VersionRangeResult result = new VersionRangeResult(request);
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionConstraint = versionScheme.parseVersionConstraint(request.getArtifact().getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            result.addException(e);
            throw new VersionRangeResolutionException(result);
        }
        result.setVersionConstraint(versionConstraint);
        if (versionConstraint.getRange() == null) {
            result.addVersion(versionConstraint.getVersion());
        } else {
            VersionRange.Bound lowerBound = versionConstraint.getRange().getLowerBound();
            VersionRange.Bound upperBound = versionConstraint.getRange().getUpperBound();
            if (lowerBound != null && lowerBound.equals(upperBound)) {
                result.addVersion(lowerBound.getVersion());
            } else {
                Metadata.Nature wantedNature;
                String natureString = ConfigUtils.getString(session, Metadata.Nature.RELEASE_OR_SNAPSHOT.name(), MAVEN_VERSION_RANGE_RESOLUTION_NATURE);
                if ("auto".equals(natureString)) {
                    Artifact upperArtifact;
                    Artifact lowerArtifact = lowerBound != null ? request.getArtifact().setVersion(lowerBound.getVersion().toString()) : null;
                    Artifact artifact = upperArtifact = upperBound != null ? request.getArtifact().setVersion(upperBound.getVersion().toString()) : null;
                    wantedNature = lowerArtifact != null && lowerArtifact.isSnapshot() || upperArtifact != null && upperArtifact.isSnapshot() ? Metadata.Nature.RELEASE_OR_SNAPSHOT : Metadata.Nature.RELEASE;
                } else {
                    wantedNature = Metadata.Nature.valueOf(natureString.toUpperCase(Locale.ROOT));
                }
                Map<String, ArtifactRepository> versionIndex = this.getVersions(session, result, request, wantedNature);
                ArrayList<Version> versions = new ArrayList<Version>();
                for (Map.Entry<String, ArtifactRepository> v : versionIndex.entrySet()) {
                    try {
                        Version ver = versionScheme.parseVersion(v.getKey());
                        if (!versionConstraint.containsVersion(ver)) continue;
                        versions.add(ver);
                        result.setRepository(ver, v.getValue());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        result.addException(e);
                    }
                }
                Collections.sort(versions);
                result.setVersions(versions);
            }
        }
        return result;
    }

    private Map<String, ArtifactRepository> getVersions(RepositorySystemSession session, VersionRangeResult result, VersionRangeRequest request, Metadata.Nature wantedNature) {
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        HashMap<String, ArtifactRepository> versionIndex = new HashMap<String, ArtifactRepository>();
        DefaultMetadata metadata = new DefaultMetadata(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), MAVEN_METADATA_XML, wantedNature);
        ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>(request.getRepositories().size());
        metadataRequests.add(new MetadataRequest(metadata, null, request.getRequestContext()));
        for (RemoteRepository repository : request.getRepositories()) {
            MetadataRequest metadataRequest = new MetadataRequest(metadata, repository, request.getRequestContext());
            metadataRequest.setDeleteLocalCopyIfMissing(true);
            metadataRequest.setTrace(trace);
            metadataRequests.add(metadataRequest);
        }
        List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session, metadataRequests);
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace != null) {
            List<String> versions = workspace.findVersions(request.getArtifact());
            for (String version : versions) {
                versionIndex.put(version, workspace.getRepository());
            }
        }
        for (MetadataResult metadataResult : metadataResults) {
            result.addException(metadataResult.getException());
            ArtifactRepository repository = metadataResult.getRequest().getRepository();
            if (repository == null) {
                repository = session.getLocalRepository();
            }
            Versioning versioning = this.readVersions(session, trace, metadataResult.getMetadata(), repository, result);
            versioning = this.filterVersionsByRepositoryType(versioning, metadataResult.getRequest().getRepository());
            for (String version : versioning.getVersions()) {
                if (versionIndex.containsKey(version)) continue;
                versionIndex.put(version, repository);
            }
        }
        return versionIndex;
    }

    private Versioning readVersions(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, VersionRangeResult result) {
        Versioning versioning;
        block13: {
            versioning = null;
            try {
                if (metadata == null) break block13;
                try (SyncContext syncContext = this.syncContextFactory.newInstance(session, true);){
                    syncContext.acquire(null, Collections.singleton(metadata));
                    if (metadata.getFile() == null || !metadata.getFile().exists()) break block13;
                    try (FileInputStream in = new FileInputStream(metadata.getFile());){
                        versioning = new MetadataXpp3Reader().read(in, false).getVersioning();
                    }
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session, trace, metadata, repository, e);
                result.addException(e);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private Versioning filterVersionsByRepositoryType(Versioning versioning, RemoteRepository remoteRepository) {
        if (remoteRepository == null) {
            return versioning;
        }
        Versioning filteredVersions = versioning.clone();
        for (String version : versioning.getVersions()) {
            if (remoteRepository.getPolicy(ArtifactUtils.isSnapshot(version)).isEnabled()) continue;
            filteredVersions.removeVersion(version);
        }
        return filteredVersions;
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

