/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystem;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.RequestTrace;
import software.amazon.smithy.cli.shaded.eclipse.aether.SyncContext;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.CollectRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.CollectResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.DependencyCollectionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.deployment.DeployRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.deployment.DeployResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.deployment.DeploymentException;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyFilter;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyVisitor;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.ArtifactDescriptorReader;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.ArtifactResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.DependencyCollector;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.Deployer;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.Installer;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.LocalRepositoryProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.MetadataResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RemoteRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RepositorySystemLifecycle;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.VersionRangeResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.VersionResolver;
import software.amazon.smithy.cli.shaded.eclipse.aether.installation.InstallRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.installation.InstallResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.installation.InstallationException;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.Authentication;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.NoLocalRepositoryManagerException;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.Proxy;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactDescriptorResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.DependencyRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.DependencyResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.DependencyResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.MetadataRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.MetadataResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRangeResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionResolutionException;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.VersionResult;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.log.LoggerFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.synccontext.SyncContextFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;
    private RepositorySystemLifecycle repositorySystemLifecycle;

    @Deprecated
    public DefaultRepositorySystem() {
    }

    @Inject
    public DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager, RepositorySystemLifecycle repositorySystemLifecycle) {
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setRepositorySystemLifecycle(repositorySystemLifecycle);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositorySystemLifecycle(locator.getService(RepositorySystemLifecycle.class));
    }

    @Deprecated
    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifact resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadata resolver cannot be null");
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.artifactDescriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        this.dependencyCollector = Objects.requireNonNull(dependencyCollector, "dependency collector cannot be null");
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        this.installer = Objects.requireNonNull(installer, "installer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        this.deployer = Objects.requireNonNull(deployer, "deployer cannot be null");
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        this.localRepositoryProvider = Objects.requireNonNull(localRepositoryProvider, "local repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultRepositorySystem setRepositorySystemLifecycle(RepositorySystemLifecycle repositorySystemLifecycle) {
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle, "repository system lifecycle cannot be null");
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.versionResolver.resolveVersion(session, request);
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.artifactDescriptorReader.readArtifactDescriptor(session, request);
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.artifactResolver.resolveArtifact(session, request);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        Objects.requireNonNull(requests, "requests cannot be null");
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session);
        Objects.requireNonNull(requests, "requests cannot be null");
        return this.metadataResolver.resolveMetadata(session, requests);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.dependencyCollector.collectDependencies(session, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List<ArtifactResult> results;
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new NullPointerException("dependency node and collect request cannot be null");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        DependencyFilter filter = request.getFilter();
        DependencyVisitor visitor = filter != null ? new FilteringDependencyVisitor(builder, filter) : builder;
        visitor = new TreeDependencyVisitor(visitor);
        if (result.getRoot() != null) {
            result.getRoot().accept(visitor);
        }
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.installer.install(session, request);
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        this.validateSession(session);
        Objects.requireNonNull(request, "request cannot be null");
        return this.deployer.deploy(session, request);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(localRepository, "localRepository cannot be null");
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        this.validateSession(session);
        return this.syncContextFactory.newInstance(session, shared);
    }

    @Override
    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.validateSession(session);
        this.validateRepositories(repositories);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    @Override
    public RemoteRepository newDeploymentRepository(RepositorySystemSession session, RemoteRepository repository) {
        this.validateSession(session);
        Objects.requireNonNull(repository, "repository cannot be null");
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        Authentication auth = session.getAuthenticationSelector().getAuthentication(repository);
        builder.setAuthentication(auth);
        Proxy proxy = session.getProxySelector().getProxy(repository);
        builder.setProxy(proxy);
        return builder.build();
    }

    @Override
    public void addOnSystemEndedHandler(Runnable handler) {
        this.repositorySystemLifecycle.addOnSystemEndedHandler(handler);
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.repositorySystemLifecycle.systemEnded();
        }
    }

    private void validateSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.invalidSession(session.getLocalRepositoryManager(), "local repository manager");
        this.invalidSession(session.getSystemProperties(), "system properties");
        this.invalidSession(session.getUserProperties(), "user properties");
        this.invalidSession(session.getConfigProperties(), "config properties");
        this.invalidSession(session.getMirrorSelector(), "mirror selector");
        this.invalidSession(session.getProxySelector(), "proxy selector");
        this.invalidSession(session.getAuthenticationSelector(), "authentication selector");
        this.invalidSession(session.getArtifactTypeRegistry(), "artifact type registry");
        this.invalidSession(session.getData(), "data");
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }

    private void validateRepositories(List<RemoteRepository> repositories) {
        Objects.requireNonNull(repositories, "repositories cannot be null");
        for (RemoteRepository repository : repositories) {
            Objects.requireNonNull(repository, "repository cannot be null");
        }
    }

    private void invalidSession(Object obj, String name) {
        Objects.requireNonNull(obj, "repository system session's " + name + " cannot be null");
    }
}

