/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.cli.dependencies.DependencyResolverException;
import software.amazon.smithy.cli.dependencies.ResolvedArtifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.version.GenericVersionScheme;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.InvalidVersionSpecificationException;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.Version;
import software.amazon.smithy.cli.shaded.eclipse.aether.version.VersionScheme;
import software.amazon.smithy.utils.SetUtils;

public final class FilterCliVersionResolver
implements DependencyResolver {
    private static final Logger LOGGER = Logger.getLogger(FilterCliVersionResolver.class.getName());
    private static final String SMITHY_GROUP = "software.amazon.smithy";
    private static final Set<String> CLI_ARTIFACTS = SetUtils.of((Object[])new String[]{"smithy-utils", "smithy-model", "smithy-build", "smithy-cli", "smithy-diff", "smithy-syntax"});
    private final String version;
    private final DependencyResolver delegate;

    public FilterCliVersionResolver(String version, DependencyResolver delegate) {
        this.version = version;
        this.delegate = delegate;
    }

    @Override
    public void addRepository(MavenRepository repository) {
        this.delegate.addRepository(repository);
    }

    @Override
    public void addDependency(String coordinates) {
        this.delegate.addDependency(coordinates);
    }

    @Override
    public List<ResolvedArtifact> resolve() {
        List<ResolvedArtifact> artifacts = this.delegate.resolve();
        if (artifacts.isEmpty()) {
            return artifacts;
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        Version parsedSmithyVersion = FilterCliVersionResolver.getMavenVersion(this.version, versionScheme);
        ArrayList<String> replacements = new ArrayList<String>();
        ArrayList<ResolvedArtifact> filtered = new ArrayList<ResolvedArtifact>();
        for (ResolvedArtifact artifact : artifacts) {
            if (artifact.getGroupId().equals(SMITHY_GROUP) && CLI_ARTIFACTS.contains(artifact.getArtifactId())) {
                Version artifactVersion = FilterCliVersionResolver.getMavenVersion(artifact.getVersion(), versionScheme);
                int compare = artifactVersion.compareTo(parsedSmithyVersion);
                if (compare > 0) {
                    throw new DependencyResolverException("The Smithy CLI is at version " + parsedSmithyVersion + ", but dependencies resolved to use a newer, incompatible version of " + artifact.getCoordinates() + ". Please update the Smithy CLI.");
                }
                if (compare >= 0) continue;
                replacements.add("- Replaced " + artifact.getCoordinates());
                continue;
            }
            filtered.add(artifact);
        }
        if (!replacements.isEmpty()) {
            String contents = String.join((CharSequence)System.lineSeparator(), replacements);
            LOGGER.info("Resolved dependencies were replaced with dependencies used by the Smithy CLI (" + this.version + "). If the CLI fails due to issues like unknown classes, methods, missing traits, etc, then consider upgrading your dependencies to match the version of the CLI or modifying your declared dependencies." + System.lineSeparator() + contents);
        }
        return filtered;
    }

    private static Version getMavenVersion(String input, VersionScheme versionScheme) {
        try {
            return versionScheme.parseVersion(input);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new DependencyResolverException("Unable to parse dependency version: " + input, e);
        }
    }
}

