/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.dependencies;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import software.amazon.smithy.cli.dependencies.DependencyResolverException;
import software.amazon.smithy.cli.dependencies.DependencyUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ChecksumUtils;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;

public final class ResolvedArtifact
implements ToNode {
    private static final String SHA_SUM_MEMBER_NAME = "sha1";
    private static final String PATH_MEMBER_NAME = "path";
    private static final String CHECKSUM_FILE_EXTENSION = ".sha1";
    private final Path path;
    private final String coordinates;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String shaSum;

    public ResolvedArtifact(Path path, String groupId, String artifactId, String version) {
        this(path, groupId + ':' + artifactId + ':' + version, groupId, artifactId, version, null);
    }

    private ResolvedArtifact(Path path, String coordinates, String groupId, String artifactId, String version, String shaSum) {
        this.coordinates = Objects.requireNonNull(coordinates);
        this.path = Objects.requireNonNull(path);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.shaSum = shaSum != null ? shaSum : ResolvedArtifact.getOrComputeSha(path);
    }

    private static String getOrComputeSha(Path path) {
        File artifactFile = path.toFile();
        File checksumFile = new File(artifactFile.getParent(), artifactFile.getName() + CHECKSUM_FILE_EXTENSION);
        try {
            if (checksumFile.exists()) {
                return ChecksumUtils.read(checksumFile);
            }
            return DependencyUtils.computeSha1(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static ResolvedArtifact fromCoordinates(Path location, String coordinates) {
        String[] parts = ResolvedArtifact.parseCoordinates(coordinates);
        return new ResolvedArtifact(location, coordinates, parts[0], parts[1], parts[2], null);
    }

    public static ResolvedArtifact fromCoordinateNode(String coordinates, Node node) {
        String[] parts = ResolvedArtifact.parseCoordinates(coordinates);
        ObjectNode objectNode = node.expectObjectNode();
        String shaSum = objectNode.expectMember(SHA_SUM_MEMBER_NAME).expectStringNode().getValue();
        Path location = Paths.get(objectNode.expectMember(PATH_MEMBER_NAME).expectStringNode().getValue(), new String[0]);
        return new ResolvedArtifact(location, coordinates, parts[0], parts[1], parts[2], shaSum);
    }

    public Path getPath() {
        return this.path;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getShaSum() {
        return this.shaSum;
    }

    public long getLastModified() {
        return this.path.toFile().lastModified();
    }

    public String toString() {
        return "{path=" + this.path + ", coordinates='" + this.coordinates + ", sha1='" + this.shaSum + "'}";
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.path, this.shaSum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact artifact = (ResolvedArtifact)o;
        return this.path.equals(artifact.path) && this.shaSum.equals(artifact.shaSum) && this.coordinates.equals(artifact.coordinates);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(PATH_MEMBER_NAME, this.path.toString()).withMember(SHA_SUM_MEMBER_NAME, this.shaSum).build();
    }

    private static String[] parseCoordinates(String coordinates) {
        String[] parts = coordinates.split(":");
        if (parts.length != 3) {
            throw new DependencyResolverException("Invalid Maven coordinates: " + coordinates);
        }
        return parts;
    }
}

