/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.dependencies;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class DependencyUtils {
    private DependencyUtils() {
    }

    public static String computeSha1(Path path) {
        String string;
        block18: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                try (DigestInputStream din = new DigestInputStream(in, md);){
                    int n;
                    byte[] object = new byte[32768];
                    while ((n = din.read(object)) > 0) {
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (byte b : md.digest()) {
                    int decimal = b & 0xFF;
                    String hex = Integer.toHexString(decimal);
                    if (hex.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(hex);
                }
                string = sb.toString();
                if (in == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return string;
    }
}

