/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic.BasicRepositoryConnector;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.RepositoryConnector;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ProvidedChecksumsSource;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.transport.TransporterProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.io.FileProcessor;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.NoRepositoryConnectorException;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;

@Named(value="basic")
public final class BasicRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    private TransporterProvider transporterProvider;
    private RepositoryLayoutProvider layoutProvider;
    private ChecksumPolicyProvider checksumPolicyProvider;
    private FileProcessor fileProcessor;
    private Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private float priority;

    public BasicRepositoryConnectorFactory() {
    }

    @Inject
    BasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        this.setTransporterProvider(transporterProvider);
        this.setRepositoryLayoutProvider(layoutProvider);
        this.setChecksumPolicyProvider(checksumPolicyProvider);
        this.setFileProcessor(fileProcessor);
        this.setProvidedChecksumSources(providedChecksumsSources);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterProvider(locator.getService(TransporterProvider.class));
        this.setRepositoryLayoutProvider(locator.getService(RepositoryLayoutProvider.class));
        this.setChecksumPolicyProvider(locator.getService(ChecksumPolicyProvider.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setProvidedChecksumSources(Collections.emptyMap());
    }

    public BasicRepositoryConnectorFactory setTransporterProvider(TransporterProvider transporterProvider) {
        this.transporterProvider = Objects.requireNonNull(transporterProvider, "transporter provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setRepositoryLayoutProvider(RepositoryLayoutProvider layoutProvider) {
        this.layoutProvider = Objects.requireNonNull(layoutProvider, "repository layout provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setChecksumPolicyProvider(ChecksumPolicyProvider checksumPolicyProvider) {
        this.checksumPolicyProvider = Objects.requireNonNull(checksumPolicyProvider, "checksum policy provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setProvidedChecksumSources(Map<String, ProvidedChecksumsSource> providedChecksumsSources) {
        this.providedChecksumsSources = Objects.requireNonNull(providedChecksumsSources, "provided checksum sources cannot be null");
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public BasicRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new BasicRepositoryConnector(session, repository, this.transporterProvider, this.layoutProvider, this.checksumPolicyProvider, this.fileProcessor, this.providedChecksumsSources);
    }
}

