/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.MultiRuntimeException;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RepositorySystemLifecycle;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.providers.DiscriminatingNameMapperProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.providers.FileGAVNameMapperProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.providers.FileHashingGAVNameMapperProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.providers.GAVNameMapperProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.synccontext.named.providers.StaticNameMapperProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.named.NamedLockFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.named.providers.FileLockNamedLockFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.named.providers.NoopNamedLockFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.named.support.NamedLockFactorySupport;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;
import software.amazon.smithy.cli.shaded.slf4j.Logger;
import software.amazon.smithy.cli.shaded.slf4j.LoggerFactory;

@Singleton
@Named
public class NamedLockFactoryAdapterFactoryImpl
implements NamedLockFactoryAdapterFactory,
Service {
    private static final String DEFAULT_FACTORY_NAME = "rwlock-local";
    private static final String DEFAULT_NAME_MAPPER_NAME = "gav";
    protected static final String FACTORY_KEY = "aether.syncContext.named.factory";
    protected static final String NAME_MAPPER_KEY = "aether.syncContext.named.nameMapper";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, NamedLockFactory> factories;
    protected final String defaultFactoryName;
    protected final Map<String, NameMapper> nameMappers;
    protected final String defaultNameMapperName;

    private static Map<String, NamedLockFactory> getManuallyCreatedFactories() {
        HashMap<String, NamedLockFactorySupport> factories = new HashMap<String, NamedLockFactorySupport>();
        factories.put("noop", new NoopNamedLockFactory());
        factories.put(DEFAULT_FACTORY_NAME, new LocalReadWriteLockNamedLockFactory());
        factories.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        factories.put("file-lock", new FileLockNamedLockFactory());
        return Collections.unmodifiableMap(factories);
    }

    private static Map<String, NameMapper> getManuallyCreatedNameMappers() {
        HashMap<String, NameMapper> mappers = new HashMap<String, NameMapper>();
        mappers.put("static", new StaticNameMapperProvider().get());
        mappers.put(DEFAULT_NAME_MAPPER_NAME, new GAVNameMapperProvider().get());
        mappers.put("discriminating", new DiscriminatingNameMapperProvider().get());
        mappers.put("file-gav", new FileGAVNameMapperProvider().get());
        mappers.put("file-hgav", new FileHashingGAVNameMapperProvider().get());
        return Collections.unmodifiableMap(mappers);
    }

    @Deprecated
    public NamedLockFactoryAdapterFactoryImpl() {
        this.factories = NamedLockFactoryAdapterFactoryImpl.getManuallyCreatedFactories();
        this.defaultFactoryName = DEFAULT_FACTORY_NAME;
        this.nameMappers = NamedLockFactoryAdapterFactoryImpl.getManuallyCreatedNameMappers();
        this.defaultNameMapperName = DEFAULT_NAME_MAPPER_NAME;
    }

    @Override
    public void initService(ServiceLocator locator) {
        locator.getService(RepositorySystemLifecycle.class).addOnSystemEndedHandler(this::shutdown);
    }

    @Inject
    public NamedLockFactoryAdapterFactoryImpl(Map<String, NamedLockFactory> factories, Map<String, NameMapper> nameMappers, RepositorySystemLifecycle lifecycle) {
        this(factories, DEFAULT_FACTORY_NAME, nameMappers, DEFAULT_NAME_MAPPER_NAME, lifecycle);
    }

    public NamedLockFactoryAdapterFactoryImpl(Map<String, NamedLockFactory> factories, String defaultFactoryName, Map<String, NameMapper> nameMappers, String defaultNameMapperName, RepositorySystemLifecycle lifecycle) {
        this.factories = Objects.requireNonNull(factories);
        this.defaultFactoryName = Objects.requireNonNull(defaultFactoryName);
        this.nameMappers = Objects.requireNonNull(nameMappers);
        this.defaultNameMapperName = Objects.requireNonNull(defaultNameMapperName);
        lifecycle.addOnSystemEndedHandler(this::shutdown);
        this.logger.debug("Created adapter factory; available factories {}; available name mappers {}", (Object)factories.keySet(), (Object)nameMappers.keySet());
    }

    @Override
    public NamedLockFactoryAdapter getAdapter(RepositorySystemSession session) {
        return this.createAdapter(session);
    }

    protected NamedLockFactoryAdapter createAdapter(RepositorySystemSession session) {
        String nameMapperName = Objects.requireNonNull(this.getNameMapperName(session));
        String factoryName = Objects.requireNonNull(this.getFactoryName(session));
        NameMapper nameMapper = this.selectNameMapper(nameMapperName);
        NamedLockFactory factory = this.selectFactory(factoryName);
        this.logger.debug("Creating adapter using nameMapper '{}' and factory '{}'", (Object)nameMapperName, (Object)factoryName);
        return new NamedLockFactoryAdapter(nameMapper, factory);
    }

    protected String getFactoryName(RepositorySystemSession session) {
        return ConfigUtils.getString(session, this.getDefaultFactoryName(), FACTORY_KEY);
    }

    protected String getDefaultFactoryName() {
        return this.defaultFactoryName;
    }

    protected String getNameMapperName(RepositorySystemSession session) {
        return ConfigUtils.getString(session, this.getDefaultNameMapperName(), NAME_MAPPER_KEY);
    }

    protected String getDefaultNameMapperName() {
        return this.defaultNameMapperName;
    }

    protected NamedLockFactory selectFactory(String factoryName) {
        NamedLockFactory factory = this.factories.get(factoryName);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: '" + factoryName + "', known ones: " + this.factories.keySet());
        }
        return factory;
    }

    protected NameMapper selectNameMapper(String nameMapperName) {
        NameMapper nameMapper = this.nameMappers.get(nameMapperName);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: '" + nameMapperName + "', known ones: " + this.nameMappers.keySet());
        }
        return nameMapper;
    }

    protected void shutdown() {
        this.logger.debug("Shutting down adapter factory; available factories {}; available name mappers {}", (Object)this.factories.keySet(), (Object)this.nameMappers.keySet());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<String, NamedLockFactory> entry : this.factories.entrySet()) {
            try {
                this.logger.debug("Shutting down '{}' factory", (Object)entry.getKey());
                entry.getValue().shutdown();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow("Problem shutting down factories", exceptions);
    }
}

