/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.commands.ProgressStyle;

final class ProgressTracker
implements AutoCloseable {
    private static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(1, runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setDaemon(true);
        return thread;
    });
    private static final long INTERVAL_MILLIS = 400L;
    private final ScheduledFuture<?> task;
    private final ProgressStyle style;
    private final Command.Env env;
    private final AtomicInteger tracker;
    private final boolean quiet;

    ProgressTracker(Command.Env env, ProgressStyle style, boolean quiet) {
        this(env, style, quiet, new AtomicInteger());
    }

    ProgressTracker(Command.Env env, ProgressStyle style, boolean quiet, AtomicInteger tracker) {
        this.env = env;
        this.style = style;
        this.quiet = quiet;
        this.tracker = tracker;
        this.task = quiet ? null : EXECUTOR.scheduleAtFixedRate(this::write, 0L, 400L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (!this.quiet) {
            this.task.cancel(false);
            try {
                EXECUTOR.schedule(this::executeClose, 0L, TimeUnit.NANOSECONDS).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
    }

    private void write() {
        this.style.updateAction(this.env, this.tracker);
        this.env.stdout().flush();
    }

    private void executeClose() {
        this.style.closeAction(this.env);
        this.env.stdout().flush();
    }
}

