/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.transfer;

import software.amazon.smithy.cli.shaded.eclipse.aether.RepositoryException;

public class ChecksumFailureException
extends RepositoryException {
    private final String expected;
    private final String expectedKind;
    private final String actual;
    private final boolean retryWorthy;

    @Deprecated
    public ChecksumFailureException(String expected, String actual) {
        this(expected, null, actual);
    }

    public ChecksumFailureException(String expected, String expectedKind, String actual) {
        super("Checksum validation failed, expected '" + expected + "'" + (expectedKind == null ? "" : " (" + expectedKind + ")") + " but is actually '" + actual + "'");
        this.expected = expected;
        this.expectedKind = expectedKind;
        this.actual = actual;
        this.retryWorthy = true;
    }

    public ChecksumFailureException(String message) {
        this(false, message, null);
    }

    public ChecksumFailureException(Throwable cause) {
        this("Checksum validation failed" + ChecksumFailureException.getMessage(": ", cause), cause);
    }

    public ChecksumFailureException(String message, Throwable cause) {
        this(false, message, cause);
    }

    public ChecksumFailureException(boolean retryWorthy, String message, Throwable cause) {
        super(message, cause);
        this.expected = "";
        this.expectedKind = "";
        this.actual = "";
        this.retryWorthy = retryWorthy;
    }

    public String getExpected() {
        return this.expected;
    }

    public String getExpectedKind() {
        return this.expectedKind;
    }

    public String getActual() {
        return this.actual;
    }

    public boolean isRetryWorthy() {
        return this.retryWorthy;
    }
}

