/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.regex.Pattern;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.CodeFormatter;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventFormatter;
import software.amazon.smithy.utils.StringUtils;

final class PrettyAnsiValidationFormatter
implements ValidationEventFormatter {
    private static final int LINE_LENGTH = 80;
    private static final Pattern TICK_PATTERN = Pattern.compile("`(.*?)`");
    private final SourceContextLoader sourceContextLoader;
    private final ColorFormatter colors;
    private final String rootPath = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();

    PrettyAnsiValidationFormatter(SourceContextLoader loader, ColorFormatter colors) {
        this.sourceContextLoader = loader;
        this.colors = colors;
    }

    public String format(ValidationEvent event) {
        String ls = System.lineSeparator();
        StringBuilder writer = new StringBuilder();
        writer.append(ls);
        switch (event.getSeverity()) {
            case WARNING: {
                this.printTitle(writer, event, Style.YELLOW, Style.BG_YELLOW, Style.BLACK);
                break;
            }
            case ERROR: {
                this.printTitle(writer, event, Style.RED, Style.BG_RED, Style.BLACK);
                break;
            }
            case DANGER: {
                this.printTitle(writer, event, Style.MAGENTA, Style.BG_MAGENTA, Style.BLACK);
                break;
            }
            case NOTE: {
                this.printTitle(writer, event, Style.CYAN, Style.BG_CYAN, Style.BLACK);
                break;
            }
            default: {
                this.printTitle(writer, event, Style.GREEN, Style.BG_GREEN, Style.BLACK);
            }
        }
        event.getShapeId().ifPresent(id -> {
            this.colors.style(writer, "Shape: ", Style.BRIGHT_BLACK);
            this.colors.style(writer, id.toString(), Style.BLUE);
            writer.append(ls);
        });
        if (event.getSourceLocation() == SourceLocation.NONE) {
            writer.append(ls);
        } else {
            String humanReadableFilename = this.getHumanReadableFilename(event.getSourceLocation().getFilename());
            int line = event.getSourceLocation().getLine();
            int column = event.getSourceLocation().getColumn();
            this.colors.style(writer, "File:  ", Style.BRIGHT_BLACK);
            this.colors.style(writer, humanReadableFilename + ':' + line + ':' + column, Style.BLUE);
            writer.append(ls).append(ls);
            try {
                Collection lines = this.sourceContextLoader.loadContext((FromSourceLocation)event);
                if (!lines.isEmpty()) {
                    new CodeFormatter(writer, this.colors, 80).writeCode(line, column, lines);
                }
            }
            catch (UncheckedIOException e) {
                this.colors.style(writer, "Invalid source file", Style.UNDERLINE);
                writer.append(": ");
                this.writeMessage(writer, e.getCause().getMessage());
                writer.append(ls).append(ls);
            }
        }
        this.writeMessage(writer, event.getMessage());
        writer.append(ls);
        return writer.toString();
    }

    private void printTitle(StringBuilder writer, ValidationEvent event, Style borderColor, Style ... styles) {
        this.colors.style(writer, "\u2500\u2500 ", borderColor);
        String severity = ' ' + event.getSeverity().toString() + ' ';
        this.colors.style(writer, severity, styles);
        this.colors.style(writer, w -> {
            w.append(" \u2500\u2500");
            int currentLength = severity.length() + 3 + 3 + 1;
            int remainingLength = 80 - currentLength;
            int padding = remainingLength - event.getId().length();
            for (int i = 0; i < padding; ++i) {
                w.append("\u2500");
            }
            w.append(' ');
        }, borderColor);
        writer.append(event.getId()).append(System.lineSeparator());
    }

    private void writeMessage(StringBuilder writer, String message) {
        String content = StringUtils.wrap((String)message, (int)80, (String)System.lineSeparator(), (boolean)false);
        if (this.colors.isColorEnabled()) {
            content = TICK_PATTERN.matcher(content).replaceAll(this.colors.style("$1", Style.CYAN));
        }
        writer.append(content);
    }

    private String getHumanReadableFilename(String filename) {
        if (filename.startsWith("jar:")) {
            filename = filename.substring(4);
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        if (filename.startsWith(this.rootPath)) {
            filename = filename.substring(this.rootPath.length() + 1);
        }
        return filename;
    }
}

