/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.DiscoveryOptions;
import software.amazon.smithy.cli.commands.PrettyAnsiValidationFormatter;
import software.amazon.smithy.cli.commands.SeverityOption;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyBuilder;

final class ModelBuilder {
    private static final Logger LOGGER = Logger.getLogger(ModelBuilder.class.getName());
    private static final String CLEAR_LINE_ESCAPE = "\u001b[2K\r";
    private static final int DEFAULT_CODE_LINES = 6;
    private Validator.Mode validationMode;
    private CliPrinter validationPrinter;
    private Arguments arguments;
    private List<String> models;
    private Command.Env env;
    private SmithyBuildConfig config;
    private Severity severity;

    ModelBuilder() {
    }

    public ModelBuilder arguments(Arguments arguments) {
        this.arguments = arguments;
        return this;
    }

    public ModelBuilder models(List<String> models) {
        this.models = models;
        return this;
    }

    public ModelBuilder env(Command.Env env) {
        this.env = env;
        return this;
    }

    public ModelBuilder validationPrinter(CliPrinter validationPrinter) {
        this.validationPrinter = validationPrinter;
        return this;
    }

    public ModelBuilder validationMode(Validator.Mode validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public ModelBuilder config(SmithyBuildConfig config) {
        this.config = config;
        return this;
    }

    public ModelBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public Model build() {
        SmithyBuilder.requiredState((String)"arguments", (Object)this.arguments);
        SmithyBuilder.requiredState((String)"models", this.models);
        SmithyBuilder.requiredState((String)"env", (Object)this.env);
        SmithyBuilder.requiredState((String)"config", (Object)this.config);
        StandardOptions standardOptions = this.arguments.getReceiver(StandardOptions.class);
        BuildOptions buildOptions = this.arguments.getReceiver(BuildOptions.class);
        DiscoveryOptions discoveryOptions = this.arguments.getReceiver(DiscoveryOptions.class);
        Severity minSeverity = this.resolveMinSeverity(standardOptions);
        ClassLoader classLoader = this.env.classLoader();
        ModelAssembler assembler = ModelBuilder.createModelAssembler(classLoader);
        ColorFormatter colors = this.env.colors();
        CliPrinter stderr = this.env.stderr();
        if (this.validationPrinter == null) {
            this.validationPrinter = this.env.stderr();
        }
        if (this.validationMode == null) {
            this.validationMode = Validator.Mode.from(standardOptions);
        }
        if (this.validationMode == Validator.Mode.DISABLE) {
            assembler.disableValidation();
        }
        AtomicInteger issueCount = new AtomicInteger();
        assembler.validationEventListener(ModelBuilder.createStatusUpdater(standardOptions, colors, stderr, issueCount));
        ModelBuilder.handleModelDiscovery(discoveryOptions, assembler, classLoader, this.config);
        ModelBuilder.handleUnknownTraitsOption(buildOptions, assembler);
        this.config.getSources().forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        this.models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        this.config.getImports().forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult result = assembler.assemble();
        ModelBuilder.clearStatusUpdateIfPresent(issueCount, stderr);
        ArrayList<ValidationEvent> sortedEvents = new ArrayList<ValidationEvent>(result.getValidationEvents());
        sortedEvents.sort(Comparator.comparing(ValidationEvent::getSourceLocation));
        SourceContextLoader sourceContextLoader = result.getResult().map(model -> SourceContextLoader.createModelAwareLoader((Model)model, (int)6)).orElseGet(() -> SourceContextLoader.createLineBasedLoader((int)6));
        PrettyAnsiValidationFormatter formatter = new PrettyAnsiValidationFormatter(sourceContextLoader, colors);
        for (ValidationEvent event : sortedEvents) {
            if (event.getSeverity().ordinal() < minSeverity.ordinal()) continue;
            this.validationPrinter.println(formatter.format(event));
        }
        Validator.validate(this.validationMode != Validator.Mode.ENABLE, colors, stderr, (ValidatedResult<Model>)result);
        this.env.stderr().flush();
        this.env.stdout().flush();
        return (Model)result.getResult().orElseThrow(() -> new RuntimeException("Expected Validator to throw"));
    }

    static Consumer<ValidationEvent> createStatusUpdater(StandardOptions standardOptions, ColorFormatter colors, CliPrinter stderr, AtomicInteger issueCount) {
        if (standardOptions.quiet() || !colors.isColorEnabled()) {
            return null;
        }
        return event -> {
            if (event.getSeverity() != Severity.SUPPRESSED) {
                int encountered = issueCount.incrementAndGet();
                String line = "Validating model: " + encountered + " issues";
                if (encountered > 1) {
                    line = '\r' + line;
                }
                stderr.print(line);
                stderr.flush();
            }
        };
    }

    static void clearStatusUpdateIfPresent(AtomicInteger issueCount, CliPrinter stderr) {
        if (issueCount.get() > 0) {
            stderr.print(CLEAR_LINE_ESCAPE);
            stderr.flush();
        }
    }

    private static void handleUnknownTraitsOption(BuildOptions options, ModelAssembler assembler) {
        if (options.allowUnknownTraits()) {
            LOGGER.fine("Ignoring unknown traits");
            assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
        }
    }

    private static void handleModelDiscovery(DiscoveryOptions options, ModelAssembler assembler, ClassLoader baseLoader, SmithyBuildConfig config) {
        if (options.discoverClasspath() != null) {
            ModelBuilder.discoverModelsWithClasspath(options.discoverClasspath(), assembler);
        } else if (ModelBuilder.shouldDiscoverDependencies(options, config)) {
            assembler.discoverModels(baseLoader);
        }
    }

    private static boolean shouldDiscoverDependencies(DiscoveryOptions options, SmithyBuildConfig config) {
        if (options.discover()) {
            return true;
        }
        return config.getMaven().isPresent() && EnvironmentVariable.SMITHY_DEPENDENCY_MODE.get().equals("standard");
    }

    private static void discoverModelsWithClasspath(String rawClasspath, ModelAssembler assembler) {
        LOGGER.finer("Discovering models with classpath: " + rawClasspath);
        String[] classpath = rawClasspath.split(System.getProperty("path.separator"));
        URL[] urls = new URL[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            try {
                urls[i] = Paths.get(classpath[i], new String[0]).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new CliError("Error parsing model discovery URL: " + classpath[i]);
            }
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls);
        assembler.discoverModels((ClassLoader)urlClassLoader);
    }

    private Severity resolveMinSeverity(StandardOptions standardOptions) {
        if (this.severity != null) {
            return this.severity;
        }
        if (this.arguments.hasReceiver(SeverityOption.class)) {
            return this.arguments.getReceiver(SeverityOption.class).severity(standardOptions);
        }
        return Severity.WARNING;
    }

    static ModelAssembler createModelAssembler(ClassLoader classLoader) {
        return Model.assembler((ClassLoader)classLoader).putProperty("assembler.disableJarCache", (Object)true);
    }
}

