/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Iterator;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.model.loader.sourcecontext.SourceContextLoader;

final class CodeFormatter {
    private final Appendable writer;
    private final ColorFormatter colors;
    private final int maxWidth;

    CodeFormatter(Appendable writer, ColorFormatter colors, int maxWidth) {
        this.writer = writer;
        this.colors = colors;
        this.maxWidth = maxWidth;
    }

    void writeCode(int cursorLine, int cursorColumn, Collection<SourceContextLoader.Line> lines) {
        if (lines.isEmpty()) {
            return;
        }
        int numberLength = this.findLongestNumber(lines);
        try {
            Iterator<SourceContextLoader.Line> lineIterator = lines.iterator();
            int lastLine = -1;
            while (lineIterator.hasNext()) {
                SourceContextLoader.Line line = lineIterator.next();
                if (line.getLineNumber() != lastLine + 1 && lastLine != -1) {
                    this.writeColumnAndContent(numberLength, -1, "");
                }
                this.writeColumnAndContent(numberLength, line.getLineNumber(), line.getContent());
                if (line.getLineNumber() == cursorLine) {
                    this.writePointer(numberLength, cursorColumn);
                }
                lastLine = line.getLineNumber();
            }
            this.writer.append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error write source code: " + e.getMessage(), e);
        }
    }

    private void writeColumnAndContent(int numberLength, int lineNumber, CharSequence content) throws IOException {
        if (lineNumber == -1) {
            this.colors.style(this.writer, w -> {
                try {
                    for (int i = 0; i < numberLength; ++i) {
                        w.append("\u00b7");
                    }
                    w.append("|");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, Style.BRIGHT_BLACK);
        } else {
            this.colors.style(this.writer, w -> {
                try {
                    String lineString = String.valueOf(lineNumber);
                    int thisLineLength = lineString.length();
                    this.writer.append(lineString);
                    for (int i = 0; i < numberLength - thisLineLength; ++i) {
                        this.writer.append(' ');
                    }
                    this.colors.style(this.writer, "| ", Style.BRIGHT_BLACK);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, Style.BRIGHT_BLACK);
        }
        if (content.length() > 0) {
            this.writeStringWithMaxWidth(content, numberLength);
        }
        this.writer.append(System.lineSeparator());
    }

    private void writePointer(int numberLength, int cursorColumn) {
        this.colors.style(this.writer, w -> {
            try {
                for (int j = 0; j < numberLength; ++j) {
                    this.writer.append(' ');
                }
                this.writer.append("|");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, Style.BRIGHT_BLACK);
        try {
            for (int j = 0; j < cursorColumn; ++j) {
                this.writer.append(' ');
            }
            this.colors.style(this.writer, "^", Style.RED);
            this.writer.append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int findLongestNumber(Collection<SourceContextLoader.Line> lines) {
        int maxLineNumber = 1;
        for (SourceContextLoader.Line line : lines) {
            maxLineNumber = line.getLineNumber();
        }
        return String.valueOf(maxLineNumber).length();
    }

    private void writeStringWithMaxWidth(CharSequence line, int offsetSize) throws IOException {
        int allowedSize = this.maxWidth - offsetSize;
        this.writer.append(line, 0, Math.min(line.length(), allowedSize));
        if (line.length() >= allowedSize) {
            this.writer.append("\u2026");
        }
    }
}

