/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.function.Consumer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.model.validation.Severity;

final class BuildOptions
implements ArgumentReceiver {
    static final String SEVERITY = "--severity";
    static final String ALLOW_UNKNOWN_TRAITS = "--allow-unknown-traits";
    static final String MODELS = "<MODELS>";
    private Severity severity;
    private String discoverClasspath;
    private boolean allowUnknownTraits;
    private boolean discover;
    private String output;

    BuildOptions() {
    }

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.param(SEVERITY, null, "SEVERITY", "Set the minimum reported validation severity (one of NOTE, WARNING [default setting], DANGER, ERROR).");
        printer.option(ALLOW_UNKNOWN_TRAITS, null, "Ignore unknown traits when validating models");
        printer.param("--output", null, "OUTPUT_PATH", "Where to write Smithy artifacts, caches, and other files (defaults to './build/smithy').");
        printer.positional(MODELS, "Model files and directories to load");
    }

    @Override
    public boolean testOption(String name) {
        switch (name) {
            case "--allow-unknown-traits": {
                this.allowUnknownTraits = true;
                return true;
            }
            case "--discover": 
            case "-d": {
                this.discover = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public Consumer<String> testParameter(String name) {
        switch (name) {
            case "--output": {
                return value -> {
                    this.output = value;
                };
            }
            case "--discover-classpath": {
                return value -> {
                    this.discoverClasspath = value;
                };
            }
            case "--severity": {
                return value -> {
                    this.severity = (Severity)Severity.fromString((String)value).orElseThrow(() -> new CliError("Invalid severity level: " + value));
                };
            }
        }
        return null;
    }

    String discoverClasspath() {
        return this.discoverClasspath;
    }

    boolean allowUnknownTraits() {
        return this.allowUnknownTraits;
    }

    boolean discover() {
        return this.discover;
    }

    String output() {
        return this.output;
    }

    Severity severity(StandardOptions options) {
        if (this.severity != null) {
            return this.severity;
        }
        if (options.quiet()) {
            return Severity.DANGER;
        }
        return Severity.WARNING;
    }
}

