/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Collections;
import java.util.List;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.SimpleCommand;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ModelSerializer;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class AstCommand
extends SimpleCommand {
    public AstCommand(String parentCommandName) {
        super(parentCommandName);
    }

    @Override
    public String getName() {
        return "ast";
    }

    @Override
    public String getSummary() {
        return "Reads Smithy models in and writes out a single JSON AST model";
    }

    @Override
    protected List<ArgumentReceiver> createArgumentReceivers() {
        return Collections.singletonList(new BuildOptions());
    }

    @Override
    protected int run(Arguments arguments, Command.Env env, List<String> models) {
        Model model = CommandUtils.buildModel(arguments, models, env, env.stderr(), true);
        ModelSerializer serializer = ModelSerializer.builder().build();
        env.stdout().println(Node.prettyPrintJson((Node)serializer.serialize(model)));
        return 0;
    }
}

