/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.function.IntConsumer;
import software.amazon.smithy.utils.SmithyUnstableApi;

@FunctionalInterface
@SmithyUnstableApi
public interface Style {
    public static final Style BOLD = new SingularCode(1);
    public static final Style FAINT = new SingularCode(2);
    public static final Style ITALIC = new SingularCode(3);
    public static final Style UNDERLINE = new SingularCode(4);
    public static final Style BLACK = new SingularCode(30);
    public static final Style RED = new SingularCode(31);
    public static final Style GREEN = new SingularCode(32);
    public static final Style YELLOW = new SingularCode(33);
    public static final Style BLUE = new SingularCode(34);
    public static final Style MAGENTA = new SingularCode(35);
    public static final Style CYAN = new SingularCode(36);
    public static final Style WHITE = new SingularCode(37);
    public static final Style BRIGHT_BLACK = new SingularCode(90);
    public static final Style BRIGHT_RED = new SingularCode(91);
    public static final Style BRIGHT_GREEN = new SingularCode(92);
    public static final Style BRIGHT_YELLOW = new SingularCode(93);
    public static final Style BRIGHT_BLUE = new SingularCode(94);
    public static final Style BRIGHT_MAGENTA = new SingularCode(95);
    public static final Style BRIGHT_CYAN = new SingularCode(96);
    public static final Style BRIGHT_WHITE = new SingularCode(97);
    public static final Style BG_BLACK = new SingularCode(40);
    public static final Style BG_RED = new SingularCode(41);
    public static final Style BG_GREEN = new SingularCode(42);
    public static final Style BG_YELLOW = new SingularCode(43);
    public static final Style BG_BLUE = new SingularCode(44);
    public static final Style BG_MAGENTA = new SingularCode(45);
    public static final Style BG_CYAN = new SingularCode(46);
    public static final Style BG_WHITE = new SingularCode(47);
    public static final Style BG_BRIGHT_BLACK = new SingularCode(100);
    public static final Style BG_BRIGHT_RED = new SingularCode(101);
    public static final Style BG_BRIGHT_GREEN = new SingularCode(102);
    public static final Style BG_BRIGHT_YELLOW = new SingularCode(103);
    public static final Style BG_BRIGHT_BLUE = new SingularCode(104);
    public static final Style BG_BRIGHT_MAGENTA = new SingularCode(105);
    public static final Style BG_BRIGHT_CYAN = new SingularCode(106);
    public static final Style BG_BRIGHT_WHITE = new SingularCode(107);

    public void pushCodes(IntConsumer var1);

    public static String format(String text, Style ... styles) {
        StringBuilder result = new StringBuilder("\u001b[");
        IntConsumer consumer = result::append;
        boolean isAfterFirst = false;
        for (Style style : styles) {
            if (isAfterFirst) {
                result.append(';');
            }
            style.pushCodes(consumer);
            isAfterFirst = true;
        }
        result.append('m');
        result.append(text);
        result.append("\u001b[0m");
        return result.toString();
    }

    public static final class SingularCode
    implements Style {
        private final int code;

        public SingularCode(int code) {
            this.code = code;
        }

        @Override
        public void pushCodes(IntConsumer codeConsumer) {
            codeConsumer.accept(this.code);
        }
    }
}

