/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.function.Consumer;
import java.util.logging.Level;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class StandardOptions
implements ArgumentReceiver {
    public static final String HELP_SHORT = "-h";
    public static final String HELP = "--help";
    public static final String DEBUG = "--debug";
    public static final String QUIET = "--quiet";
    public static final String STACKTRACE = "--stacktrace";
    public static final String NO_COLOR = "--no-color";
    public static final String FORCE_COLOR = "--force-color";
    public static final String LOGGING = "--logging";
    public static final String SEVERITY = "--severity";
    private boolean help;
    private Severity severity = Severity.WARNING;
    private Level logging = Level.WARNING;
    private boolean quiet;
    private boolean debug;
    private boolean stackTrace;
    private boolean noColor;
    private boolean forceColor;

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.option(HELP, HELP_SHORT, "Prints this help output");
        printer.option(DEBUG, null, "Display debug information");
        printer.option(QUIET, null, "Silences all output except errors");
        printer.option(STACKTRACE, null, "Display a stacktrace on error");
        printer.option(NO_COLOR, null, "Explicitly disable ANSI colors");
        printer.option(FORCE_COLOR, null, "Explicitly enable ANSI colors");
        printer.param(LOGGING, null, "LOG_LEVEL", "Sets the log level (defaults to WARNING). Set to one of OFF, SEVERE, WARNING, INFO, FINE, ALL.");
        printer.param(SEVERITY, null, "SEVERITY", "Sets the minimum reported validation severity to report. Set to one of NOTE, WARNING (default), DANGER, ERROR");
    }

    @Override
    public boolean testOption(String name) {
        switch (name) {
            case "--help": 
            case "-h": {
                this.help = true;
                return true;
            }
            case "--debug": {
                this.debug = true;
                this.quiet = false;
                this.logging = Level.ALL;
                return true;
            }
            case "--quiet": {
                this.quiet = true;
                this.debug = false;
                this.logging = Level.SEVERE;
                this.severity = Severity.DANGER;
                return true;
            }
            case "--stacktrace": {
                this.stackTrace = true;
                return true;
            }
            case "--no-color": {
                this.noColor = true;
                this.forceColor = false;
                return true;
            }
            case "--force-color": {
                this.noColor = false;
                this.forceColor = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public Consumer<String> testParameter(String name) {
        switch (name) {
            case "--logging": {
                return value -> {
                    try {
                        this.logging = Level.parse(value);
                    }
                    catch (IllegalArgumentException e) {
                        throw new CliError("Invalid logging level: " + value);
                    }
                };
            }
            case "--severity": {
                return value -> {
                    this.severity = (Severity)Severity.fromString((String)value).orElseThrow(() -> new CliError("Invalid severity level: " + value));
                };
            }
        }
        return null;
    }

    public boolean help() {
        return this.help;
    }

    public Severity severity() {
        return this.severity;
    }

    public Level logging() {
        return this.logging;
    }

    public boolean quiet() {
        return this.quiet;
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean stackTrace() {
        return this.stackTrace;
    }

    public boolean noColor() {
        return this.noColor;
    }

    public boolean forceColor() {
        return this.forceColor;
    }
}

