/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.utils.SmithyBuilder;

public final class Parser {
    private String positionalName;
    private String positionalHelp;
    private List<Argument> argumentList;
    private Map<String, Argument> argumentMap = new HashMap<String, Argument>();

    private Parser(Builder builder) {
        this.argumentList = builder.arguments;
        this.positionalName = builder.positionalName;
        this.positionalHelp = builder.positionalHelp;
        for (Argument argument : this.argumentList) {
            argument.getShortName().ifPresent(name -> this.argumentMap.put((String)name, argument));
            argument.getLongName().ifPresent(name -> this.argumentMap.put((String)name, argument));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getPositionalName() {
        return Optional.ofNullable(this.positionalName);
    }

    public Optional<String> getPositionalHelp() {
        return Optional.ofNullable(this.positionalHelp);
    }

    public List<Argument> getArgs() {
        return this.argumentList;
    }

    public Arguments parse(String[] args) {
        return this.parse(args, 0);
    }

    public Arguments parse(String[] args, int offset) {
        Objects.requireNonNull(args);
        String currentArg = null;
        boolean consumeRemaining = false;
        HashMap<String, List<String>> parsedArgs = new HashMap<String, List<String>>();
        ArrayList<String> parsedOpts = new ArrayList<String>();
        for (int i = offset; i < args.length; ++i) {
            String arg = args[i];
            if (consumeRemaining) {
                parsedOpts.add(arg);
                continue;
            }
            if (currentArg != null) {
                ((List)parsedArgs.get(currentArg)).add(arg);
                currentArg = null;
                continue;
            }
            if (arg.equals("--") || !arg.startsWith("-")) {
                if (!arg.equals("--")) {
                    parsedOpts.add(arg);
                }
                consumeRemaining = true;
                currentArg = null;
                continue;
            }
            if (!this.argumentMap.containsKey(arg)) {
                throw new CliError(String.format("Invalid argument %s. Expected one of: %s", arg, this.argumentMap.keySet().stream().sorted().collect(Collectors.toList())));
            }
            currentArg = this.argumentMap.get(arg).getCanonicalName();
            if (!parsedArgs.containsKey(currentArg)) {
                parsedArgs.put(currentArg, new ArrayList());
                if (this.argumentMap.get(currentArg).arity != Arity.NONE) continue;
                currentArg = null;
                continue;
            }
            if (this.argumentMap.get(currentArg).arity == Arity.MANY) continue;
            throw new CliError("Conflicting arguments provided for " + currentArg);
        }
        if (currentArg != null) {
            throw new CliError("Missing argument value for " + currentArg);
        }
        if (!parsedOpts.isEmpty() && this.positionalName == null) {
            throw new CliError("Unexpected options provided: [" + parsedOpts + "]");
        }
        return new Arguments(parsedArgs, parsedOpts);
    }

    public static final class Builder
    implements SmithyBuilder<Parser> {
        private String positionalName;
        private String positionalHelp;
        private List<Argument> arguments = new ArrayList<Argument>();

        private Builder() {
            this.option("--help", "-h", "Print this help");
            this.option("--debug", "Display debug information");
            this.option("--stacktrace", "Display a stacktrace on error");
            this.option("--no-color", "Explicitly disable ANSI colors");
            this.option("--force-color", "Explicitly enables ANSI colors");
            this.option("--quiet-logs", "Disables writing log messages to STDOUT");
        }

        public Parser build() {
            return new Parser(this);
        }

        public Builder positional(String name, String help) {
            this.positionalName = name;
            this.positionalHelp = help;
            return this;
        }

        public Builder argument(Argument argument) {
            this.arguments.add(Objects.requireNonNull(argument));
            return this;
        }

        public Builder option(String shortName, String longName, String help) {
            return this.argument(new Argument(shortName, longName, Arity.NONE, help));
        }

        public Builder option(String longName, String help) {
            return this.argument(new Argument(longName, null, Arity.NONE, help));
        }

        public Builder parameter(String shortName, String longName, String help) {
            return this.argument(new Argument(shortName, longName, Arity.ONE, help));
        }

        public Builder parameter(String longName, String help) {
            return this.argument(new Argument(null, longName, Arity.ONE, help));
        }

        public Builder repeatedParameter(String shortName, String longName, String help) {
            return this.argument(new Argument(shortName, longName, Arity.MANY, help));
        }

        public Builder repeatedParameter(String longName, String help) {
            return this.argument(new Argument(longName, null, Arity.MANY, help));
        }
    }

    public static final class Argument {
        private String shortName;
        private String longName;
        private Arity arity;
        private String help;

        public Argument(String longName, String shortName, Arity arity, String help) {
            if (shortName == null && longName == null) {
                throw new IllegalArgumentException("A CLI argument must have a long name, short name, or both");
            }
            if (longName != null && !longName.startsWith("-")) {
                throw new IllegalArgumentException("longName must start with '-': " + longName);
            }
            if (shortName != null && !shortName.startsWith("-")) {
                throw new IllegalArgumentException("shortName must start with '-': " + shortName);
            }
            this.longName = longName;
            this.shortName = shortName;
            this.arity = Objects.requireNonNull(arity);
            this.help = Objects.requireNonNull(help);
        }

        public Optional<String> getShortName() {
            return Optional.ofNullable(this.shortName);
        }

        public Optional<String> getLongName() {
            return Optional.ofNullable(this.longName);
        }

        public String getCanonicalName() {
            return this.longName != null ? this.longName : this.shortName;
        }

        public Arity getArity() {
            return this.arity;
        }

        public String getHelp() {
            return this.help;
        }
    }

    public static enum Arity {
        NONE,
        ONE,
        MANY;

    }
}

