/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.ValidatedResult;

public final class ValidateCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(ValidateCommand.class.getName());

    @Override
    public String getName() {
        return "validate";
    }

    @Override
    public String getSummary() {
        return "Validates Smithy models";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().option("--allow-unknown-traits", "Ignores unknown traits when validating models").option("--discover", "-d", "Enables model discovery, merging in models found inside of jars").parameter("--discover-classpath", "Enables model discovery using a custom classpath for models").positional("<MODELS>", "Path to Smithy models or directories").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        List<String> models = arguments.positionalArguments();
        LOGGER.info(String.format("Validating Smithy model sources: %s", models));
        ModelAssembler assembler = Model.assembler((ClassLoader)classLoader);
        CommandUtils.handleModelDiscovery(arguments, assembler, classLoader);
        CommandUtils.handleUnknownTraitsOption(arguments, assembler);
        models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult modelResult = assembler.assemble();
        Validator.validate((ValidatedResult<Model>)modelResult);
        Colors.out(Colors.BRIGHT_BOLD_GREEN, "Smithy validation complete");
    }
}

