/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.openapi.CorsHeader;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.utils.ListUtils;

final class AddCorsToGatewayResponses
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddCorsToGatewayResponses.class.getName());
    private static final ObjectNode DEFAULT_GATEWAY_RESPONSE = Node.objectNode().withMember("responseTemplates", (ToNode)Node.objectNode().withMember("application/json", "{\"message\":$context.error.messageString}"));
    private static final ObjectNode DEFAULT_GATEWAY_RESPONSES = Node.objectNodeBuilder().withMember("DEFAULT_4XX", (ToNode)DEFAULT_GATEWAY_RESPONSE).withMember("DEFAULT_5XX", (ToNode)DEFAULT_GATEWAY_RESPONSE).build();
    private static final String GATEWAY_RESPONSES_EXTENSION = "x-amazon-apigateway-gateway-responses";
    private static final String HEADER_PREFIX = "gatewayresponse.header.";
    private static final String RESPONSE_PARAMETERS_KEY = "responseParameters";

    AddCorsToGatewayResponses() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST));
    }

    public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
        return context.getService().getTrait(CorsTrait.class).map(corsTrait -> this.updateModel(context, openapi, (CorsTrait)corsTrait)).orElse(openapi);
    }

    private OpenApi updateModel(Context<? extends Trait> context, OpenApi openapi, CorsTrait corsTrait) {
        Node extension = openapi.getExtension(GATEWAY_RESPONSES_EXTENSION).map(node -> node.expectObjectNode("x-amazon-apigateway-gateway-responses must be an object")).map(node -> this.updateGatewayResponses(context, corsTrait, (ObjectNode)node)).orElse(this.updateGatewayResponses(context, corsTrait));
        return ((OpenApi.Builder)openapi.toBuilder().putExtension(GATEWAY_RESPONSES_EXTENSION, extension)).build();
    }

    private Node updateGatewayResponses(Context<? extends Trait> context, CorsTrait trait) {
        LOGGER.fine(() -> "Injecting default API Gateway responses for " + context.getService().getId());
        return this.updateGatewayResponses(context, trait, DEFAULT_GATEWAY_RESPONSES);
    }

    private Node updateGatewayResponses(Context<? extends Trait> context, CorsTrait trait, ObjectNode gatewayResponses) {
        HashMap<CorsHeader, String> corsHeaders = new HashMap<CorsHeader, String>();
        corsHeaders.put(CorsHeader.ALLOW_ORIGIN, trait.getOrigin());
        if (context.usesHttpCredentials()) {
            corsHeaders.put(CorsHeader.ALLOW_CREDENTIALS, "true");
        }
        return (Node)gatewayResponses.getMembers().entrySet().stream().collect(ObjectNode.collect(Map.Entry::getKey, entry -> this.updateGatewayResponse(context, trait, corsHeaders, ((Node)entry.getValue()).expectObjectNode())));
    }

    private ObjectNode updateGatewayResponse(Context<? extends Trait> context, CorsTrait trait, Map<CorsHeader, String> sharedHeaders, ObjectNode gatewayResponse) {
        ObjectNode responseParameters = gatewayResponse.getObjectMember(RESPONSE_PARAMETERS_KEY).orElse(Node.objectNode());
        TreeMap<CorsHeader, String> headers = new TreeMap<CorsHeader, String>(sharedHeaders);
        TreeSet<String> exposedHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        exposedHeaders.addAll(trait.getAdditionalExposedHeaders());
        for (String key : responseParameters.getStringMap().keySet()) {
            if (!key.startsWith(HEADER_PREFIX)) continue;
            exposedHeaders.add(key.substring(HEADER_PREFIX.length()));
        }
        if (!exposedHeaders.isEmpty()) {
            headers.put(CorsHeader.EXPOSE_HEADERS, String.join((CharSequence)",", exposedHeaders));
        }
        ObjectNode.Builder responseBuilder = responseParameters.toBuilder();
        for (Map.Entry entry : headers.entrySet()) {
            String key = HEADER_PREFIX + ((CorsHeader)((Object)entry.getKey())).toString();
            if (responseParameters.getMember(key).isPresent()) continue;
            responseBuilder.withMember(key, "'" + (String)entry.getValue() + "'");
        }
        return gatewayResponse.withMember(RESPONSE_PARAMETERS_KEY, (ToNode)responseBuilder.build());
    }
}

