/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayDefaults;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.openapi.OpenApiConfig;

final class AddDefaultConfigSettings
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddDefaultConfigSettings.class.getName());
    private static final ApiGatewayDefaults DEFAULT_VERSION = ApiGatewayDefaults.VERSION_2023_08_11;

    AddDefaultConfigSettings() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return null;
    }

    public void updateDefaultSettings(Model model, OpenApiConfig openApiConfig) {
        ApiGatewayConfig config = (ApiGatewayConfig)openApiConfig.getExtensions(ApiGatewayConfig.class);
        if (config.getApiGatewayDefaults() == null) {
            LOGGER.warning(String.format("`apiGatewayDefaults` configuration not set for opeanapi plugin. Assuming %s.", new Object[]{DEFAULT_VERSION}));
            config.setApiGatewayDefaults(DEFAULT_VERSION);
        }
        config.getApiGatewayDefaults().setDefaults(openApiConfig);
    }
}

