/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.Map;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiConfig;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.OpenApiMapper;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.RequestBodyObject;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.openapi.model.SecurityScheme;

public interface ApiGatewayMapper
extends OpenApiMapper {
    public List<ApiGatewayConfig.ApiType> getApiTypes();

    public static OpenApiMapper wrap(final ApiGatewayMapper delegate) {
        return new OpenApiMapper(){

            private boolean matchesApiType(Context<?> context) {
                return this.matchesApiType(context.getConfig());
            }

            private boolean matchesApiType(OpenApiConfig openApiConfig) {
                ApiGatewayConfig config = (ApiGatewayConfig)openApiConfig.getExtensions(ApiGatewayConfig.class);
                ApiGatewayConfig.ApiType setting = config.getApiGatewayType();
                if (setting == ApiGatewayConfig.ApiType.DISABLED) {
                    return false;
                }
                List<ApiGatewayConfig.ApiType> supported = delegate.getApiTypes();
                if (supported == null || supported.isEmpty()) {
                    return true;
                }
                return supported.contains((Object)setting);
            }

            public byte getOrder() {
                return delegate.getOrder();
            }

            public void updateDefaultSettings(Model model, OpenApiConfig config) {
                if (this.matchesApiType(config)) {
                    delegate.updateDefaultSettings(model, config);
                }
            }

            public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethodName, String path) {
                return this.matchesApiType(context) ? delegate.updateOperation(context, shape, operation, httpMethodName, path) : operation;
            }

            public PathItem updatePathItem(Context<? extends Trait> context, String path, PathItem pathItem) {
                return this.matchesApiType(context) ? delegate.updatePathItem(context, path, pathItem) : pathItem;
            }

            public ParameterObject updateParameter(Context<? extends Trait> context, OperationShape operation, String httpMethodName, String path, ParameterObject parameterObject) {
                return this.matchesApiType(context) ? delegate.updateParameter(context, operation, httpMethodName, path, parameterObject) : parameterObject;
            }

            public RequestBodyObject updateRequestBody(Context<? extends Trait> context, OperationShape operation, String httpMethodName, String path, RequestBodyObject requestBody) {
                return this.matchesApiType(context) ? delegate.updateRequestBody(context, operation, httpMethodName, path, requestBody) : requestBody;
            }

            public ResponseObject updateResponse(Context<? extends Trait> context, OperationShape operation, String status, String httpMethodName, String path, ResponseObject response) {
                return this.matchesApiType(context) ? delegate.updateResponse(context, operation, status, httpMethodName, path, response) : response;
            }

            public void before(Context<? extends Trait> context, OpenApi.Builder builder) {
                if (this.matchesApiType(context)) {
                    delegate.before(context, builder);
                }
            }

            public SecurityScheme updateSecurityScheme(Context<? extends Trait> context, Trait authTrait, SecurityScheme securityScheme) {
                return this.matchesApiType(context) ? delegate.updateSecurityScheme(context, authTrait, securityScheme) : securityScheme;
            }

            public Map<String, List<String>> updateSecurity(Context<? extends Trait> context, Shape shape, SecuritySchemeConverter<? extends Trait> converter, Map<String, List<String>> requirement) {
                return this.matchesApiType(context) ? delegate.updateSecurity(context, shape, converter, requirement) : requirement;
            }

            public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
                return this.matchesApiType(context) ? delegate.after(context, openapi) : openapi;
            }

            public ObjectNode updateNode(Context<? extends Trait> context, OpenApi openapi, ObjectNode node) {
                return this.matchesApiType(context) ? delegate.updateNode(context, openapi, node) : node;
            }
        };
    }
}

