/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.protocol.railsjson.generators;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.generators.RestParserGeneratorBase;
import software.amazon.smithy.ruby.codegen.traits.NoSerializeTrait;
import software.amazon.smithy.ruby.codegen.util.TimestampFormat;

public class ParserGenerator
extends RestParserGeneratorBase {
    public ParserGenerator(GenerationContext context) {
        super(context);
    }

    protected void renderBodyParser(Shape outputShape) {
        List<MemberShape> parseMembers = this.parseMembers(outputShape.members());
        if (!parseMembers.isEmpty()) {
            this.writer.write((Object)"map = $T.parse(http_resp.body.read)", new Object[]{Hearth.JSON});
            this.renderMemberParsers(parseMembers);
        }
    }

    protected void renderMapParseMethod(MapShape s) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.parse(map)", new Object[0])).write((Object)"data = {}", new Object[0])).openBlock("map.map do |key, value|", new Object[0])).call(() -> {
            Shape valueTarget = this.model.expectShape(s.getValue().getTarget());
            valueTarget.accept((ShapeVisitor)new MemberDeserializer(s.getValue(), "data[key] = ", "value", !s.hasTrait(SparseTrait.class)));
        })).closeBlock("end", new Object[0])).write((Object)"data", new Object[0])).closeBlock("end", new Object[0]);
    }

    protected void renderListParseMethod(ListShape s) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.parse(list)", new Object[0])).openBlock("list.map do |value|", new Object[0])).call(() -> {
            Shape memberTarget = this.model.expectShape(s.getMember().getTarget());
            memberTarget.accept((ShapeVisitor)new MemberDeserializer(s.getMember(), "", "value", !s.hasTrait(SparseTrait.class)));
        })).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }

    protected void renderStructureParseMethod(StructureShape s) {
        List<MemberShape> parseMembers = this.parseMembers(s.members());
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.parse(map)", new Object[0])).write((Object)"data = Types::$L.new", new Object[]{this.symbolProvider.toSymbol((Shape)s).getName()})).call(() -> this.renderMemberParsers(parseMembers))).write((Object)"data", new Object[0])).closeBlock("end", new Object[0]);
    }

    protected void renderUnionParseMethod(UnionShape s) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.parse(map)", new Object[0])).write((Object)"key, value = map.flatten", new Object[0])).write((Object)"return nil if key.nil?\n", new Object[0])).write((Object)"case key", new Object[0])).call(() -> s.members().forEach(member -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write((Object)"when '$L'", new Object[]{this.unionMemberDataName(s, (MemberShape)member)})).indent()).call(() -> this.renderUnionMemberParser(s, (MemberShape)member))).write((Object)"$T.new(value) if value", new Object[]{this.context.symbolProvider().toSymbol((Shape)member)})).dedent()))).openBlock("else", new Object[0])).write((Object)"$T::Unknown.new(name: key, value: value)", new Object[]{this.context.symbolProvider().toSymbol((Shape)s)})).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }

    private String unionMemberDataName(UnionShape s, MemberShape member) {
        String dataName;
        String jsonName = dataName = RubyFormatter.toSnakeCase((String)this.symbolProvider.toMemberName(member));
        if (member.hasTrait(JsonNameTrait.class)) {
            jsonName = ((JsonNameTrait)member.getTrait(JsonNameTrait.class).get()).getValue();
        }
        return jsonName;
    }

    private void renderUnionMemberParser(UnionShape s, MemberShape member) {
        Shape target = this.model.expectShape(member.getTarget());
        target.accept((ShapeVisitor)new UnionMemberDeserializer(member, "value = ", "value", false));
    }

    protected void renderPayloadBodyParser(Shape outputShape, MemberShape payloadMember, Shape target) {
        if (target.hasTrait(StreamingTrait.class)) {
            this.renderStreamingBodyParser(outputShape);
        } else {
            String dataName = this.symbolProvider.toMemberName(payloadMember);
            String dataSetter = "data." + dataName + " = ";
            target.accept((ShapeVisitor)new PayloadMemberDeserializer(dataSetter));
        }
    }

    private void renderMemberParsers(List<MemberShape> parseMembers) {
        parseMembers.forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String dataName = this.symbolProvider.toMemberName(member);
            String dataSetter = "data." + dataName + " = ";
            String jsonName = RubyFormatter.toSnakeCase((String)member.getMemberName());
            if (member.hasTrait(JsonNameTrait.class)) {
                jsonName = ((JsonNameTrait)member.getTrait(JsonNameTrait.class).get()).getValue();
            }
            String valueGetter = "map['" + jsonName + "']";
            target.accept((ShapeVisitor)new MemberDeserializer((MemberShape)member, dataSetter, valueGetter, !member.hasTrait(SparseTrait.class)));
        });
    }

    private List<MemberShape> parseMembers(Collection<MemberShape> members) {
        return members.stream().filter(m -> !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class) && !m.hasTrait(HttpResponseCodeTrait.class)).filter(NoSerializeTrait.excludeNoSerializeMembers()).collect(Collectors.toList());
    }

    private class UnionMemberDeserializer
    extends MemberDeserializer {
        UnionMemberDeserializer(MemberShape memberShape, String dataSetter, String jsonGetter, boolean checkRequired) {
            super(memberShape, dataSetter, jsonGetter, checkRequired);
        }

        @Override
        protected Void getDefault(Shape shape) {
            return null;
        }
    }

    private class PayloadMemberDeserializer
    extends ShapeVisitor.Default<Void> {
        private final String dataSetter;

        PayloadMemberDeserializer(String dataSetter) {
            this.dataSetter = dataSetter;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            ((RubyCodeWriter)ParserGenerator.this.writer.write((Object)"payload = http_resp.body.read", new Object[0])).write((Object)"$Lpayload unless payload.empty?", new Object[]{this.dataSetter});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            ((RubyCodeWriter)ParserGenerator.this.writer.write((Object)"payload = http_resp.body.read", new Object[0])).write((Object)"$Lpayload unless payload.empty?", new Object[]{this.dataSetter});
            return null;
        }

        public Void documentShape(DocumentShape shape) {
            ((RubyCodeWriter)ParserGenerator.this.writer.write((Object)"payload = $T.parse(http_resp.body.read)", new Object[]{Hearth.JSON})).write((Object)"$Lpayload", new Object[]{this.dataSetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        private void defaultComplexDeserializer(Shape shape) {
            ((RubyCodeWriter)ParserGenerator.this.writer.write((Object)"map = $T.parse(http_resp.body.read)", new Object[]{Hearth.JSON})).write((Object)"$LParsers::$L.parse(map)", new Object[]{this.dataSetter, ParserGenerator.this.symbolProvider.toSymbol(shape).getName()});
        }
    }

    private class MemberDeserializer
    extends ShapeVisitor.Default<Void> {
        private final String jsonGetter;
        private final String dataSetter;
        private final MemberShape memberShape;
        private final boolean checkRequired;

        MemberDeserializer(MemberShape memberShape, String dataSetter, String jsonGetter, boolean checkRequired) {
            this.jsonGetter = jsonGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
            this.checkRequired = checkRequired;
        }

        private String checkRequired() {
            if (this.checkRequired) {
                return " unless " + this.jsonGetter + ".nil?";
            }
            return "";
        }

        protected Void getDefault(Shape shape) {
            ParserGenerator.this.writer.write((Object)"$L$L$L", new Object[]{this.dataSetter, this.jsonGetter, this.checkRequired()});
            return null;
        }

        private void rubyFloat() {
            ParserGenerator.this.writer.write((Object)"$L$T.deserialize($L)$L", new Object[]{this.dataSetter, Hearth.NUMBER_HELPER, this.jsonGetter, this.checkRequired()});
        }

        public Void doubleShape(DoubleShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void floatShape(FloatShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void blobShape(BlobShape shape) {
            ParserGenerator.this.writer.write((Object)"$1L$3T::decode64($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.jsonGetter, RubyImportContainer.BASE64});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            ParserGenerator.this.writer.write((Object)"$L$L if $L", new Object[]{this.dataSetter, TimestampFormat.parseTimestamp((TimestampShape)shape, (MemberShape)this.memberShape, (String)this.jsonGetter, (TimestampFormatTrait.Format)TimestampFormatTrait.Format.DATE_TIME), this.jsonGetter});
            return null;
        }

        private void defaultComplexDeserializer(Shape shape) {
            if (this.checkRequired) {
                ParserGenerator.this.writer.write((Object)"$1LParsers::$2L.parse($3L) unless $3L.nil?", new Object[]{this.dataSetter, ParserGenerator.this.symbolProvider.toSymbol(shape).getName(), this.jsonGetter});
            } else {
                ParserGenerator.this.writer.write((Object)"$1L(Parsers::$2L.parse($3L) unless $3L.nil?)", new Object[]{this.dataSetter, ParserGenerator.this.symbolProvider.toSymbol(shape).getName(), this.jsonGetter});
            }
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexDeserializer((Shape)shape);
            return null;
        }
    }
}

