/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.protocol.railsjson.generators;

import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.generators.RestBuilderGeneratorBase;
import software.amazon.smithy.ruby.codegen.traits.NoSerializeTrait;
import software.amazon.smithy.ruby.codegen.util.TimestampFormat;

public class BuilderGenerator
extends RestBuilderGeneratorBase {
    public BuilderGenerator(GenerationContext context) {
        super(context);
    }

    private void renderMemberBuilders(Shape s) {
        Stream<MemberShape> serializeMembers = s.members().stream().filter(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class));
        serializeMembers = serializeMembers.filter(NoSerializeTrait.excludeNoSerializeMembers());
        serializeMembers.forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(member);
            Object dataName = RubyFormatter.asSymbol((String)member.getMemberName());
            if (member.hasTrait(JsonNameTrait.class)) {
                dataName = "'" + ((JsonNameTrait)member.expectTrait(JsonNameTrait.class)).getValue() + "'";
            }
            if (member.hasTrait("smithy.ruby.protocols#nestedAttributes")) {
                dataName = (String)dataName + "_attributes";
            }
            String dataSetter = "data[" + (String)dataName + "] = ";
            String inputGetter = "input[" + symbolName + "]";
            target.accept((ShapeVisitor)new MemberSerializer((MemberShape)member, dataSetter, inputGetter, !s.hasTrait(SparseTrait.class)));
        });
    }

    protected void renderPayloadBodyBuilder(OperationShape operation, Shape inputShape, MemberShape payloadMember, Shape target) {
        String symbolName = ":" + this.symbolProvider.toMemberName(payloadMember);
        String inputGetter = "input[" + symbolName + "]";
        if (target.hasTrait(StreamingTrait.class)) {
            this.renderStreamingBodyBuilder(inputShape);
        } else {
            target.accept((ShapeVisitor)new PayloadMemberSerializer(payloadMember, inputGetter));
        }
    }

    protected void renderBodyBuilder(OperationShape operation, Shape inputShape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write((Object)"http_req.headers['Content-Type'] = 'application/json'", new Object[0])).write((Object)"data = {}", new Object[0])).call(() -> this.renderMemberBuilders(inputShape))).write((Object)"http_req.body = StringIO.new(Hearth::JSON.dump(data))", new Object[0]);
    }

    protected void renderStructureBuildMethod(StructureShape shape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.build(input)", new Object[0])).write((Object)"data = {}", new Object[0])).call(() -> this.renderMemberBuilders((Shape)shape))).write((Object)"data", new Object[0])).closeBlock("end", new Object[0]);
    }

    protected void renderListBuildMethod(ListShape shape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.build(input)", new Object[0])).write((Object)"data = []", new Object[0])).openBlock("input.each do |element|", new Object[0])).call(() -> {
            Shape memberTarget = this.model.expectShape(shape.getMember().getTarget());
            memberTarget.accept((ShapeVisitor)new MemberSerializer(shape.getMember(), "data << ", "element", !shape.hasTrait(SparseTrait.class)));
        })).closeBlock("end", new Object[0])).write((Object)"data", new Object[0])).closeBlock("end", new Object[0]);
    }

    protected void renderUnionBuildMethod(UnionShape shape) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)shape);
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.build(input)", new Object[0])).write((Object)"data = {}", new Object[0])).write((Object)"case input", new Object[0]);
        shape.members().forEach(member -> {
            ((RubyCodeWriter)this.writer.write((Object)"when $T", new Object[]{this.symbolProvider.toSymbol((Shape)member)})).indent();
            this.renderUnionMemberBuilder((MemberShape)member);
            this.writer.dedent();
        });
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("else", new Object[0])).write((Object)"raise ArgumentError,\n\"Expected input to be one of the subclasses of Types::$L\"", new Object[]{symbol.getName()})).closeBlock("end", new Object[0])).write((Object)"", new Object[0])).write((Object)"data", new Object[0])).closeBlock("end", new Object[0]);
    }

    protected void renderMapBuildMethod(MapShape shape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.build(input)", new Object[0])).write((Object)"data = {}", new Object[0])).openBlock("input.each do |key, value|", new Object[0])).call(() -> {
            Shape valueTarget = this.model.expectShape(shape.getValue().getTarget());
            valueTarget.accept((ShapeVisitor)new MemberSerializer(shape.getValue(), "data[key] = ", "value", !shape.hasTrait(SparseTrait.class)));
        })).closeBlock("end", new Object[0])).write((Object)"data", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderUnionMemberBuilder(MemberShape member) {
        Shape target = this.model.expectShape(member.getTarget());
        Object dataName = RubyFormatter.asSymbol((String)this.symbolProvider.toMemberName(member));
        if (member.hasTrait(JsonNameTrait.class)) {
            dataName = "'" + ((JsonNameTrait)member.expectTrait(JsonNameTrait.class)).getValue() + "'";
        }
        String dataSetter = "data[" + (String)dataName + "] = ";
        target.accept((ShapeVisitor)new MemberSerializer(member, dataSetter, "input", false));
    }

    private class PayloadMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;
        private final String inputGetter;

        PayloadMemberSerializer(MemberShape memberShape, String inputGetter) {
            this.memberShape = memberShape;
            this.inputGetter = inputGetter;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            ((RubyCodeWriter)BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = 'text/plain'", new Object[0])).write((Object)"http_req.body = StringIO.new($L || '')", new Object[]{this.inputGetter});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            Optional mediaTypeTrait = shape.getTrait(MediaTypeTrait.class);
            String mediaType = "application/octet-stream";
            if (mediaTypeTrait.isPresent()) {
                mediaType = ((MediaTypeTrait)mediaTypeTrait.get()).getValue();
            }
            ((RubyCodeWriter)BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = '$L'", new Object[]{mediaType})).write((Object)"http_req.body = StringIO.new($L || '')", new Object[]{this.inputGetter});
            return null;
        }

        public Void documentShape(DocumentShape shape) {
            ((RubyCodeWriter)BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = 'application/json'", new Object[0])).write((Object)"http_req.body = StringIO.new(Hearth::JSON.dump($1L))", new Object[]{this.inputGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        private void defaultComplexSerializer(Shape shape) {
            ((RubyCodeWriter)((RubyCodeWriter)BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = 'application/json'", new Object[0])).write((Object)"data = Builders::$1L.build($2L) unless $2L.nil?", new Object[]{BuilderGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter})).write((Object)"http_req.body = StringIO.new(Hearth::JSON.dump(data || {}))", new Object[0]);
        }
    }

    private class MemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String dataSetter;
        private final MemberShape memberShape;
        private final boolean checkRequired;

        MemberSerializer(MemberShape memberShape, String dataSetter, String inputGetter, boolean checkRequired) {
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
            this.checkRequired = checkRequired;
        }

        private String checkRequired() {
            if (this.checkRequired) {
                return " unless " + this.inputGetter + ".nil?";
            }
            return "";
        }

        protected Void getDefault(Shape shape) {
            BuilderGenerator.this.writer.write((Object)"$L$L$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
            return null;
        }

        private void rubyFloat() {
            BuilderGenerator.this.writer.write((Object)"$L$T.serialize($L)$L", new Object[]{this.dataSetter, Hearth.NUMBER_HELPER, this.inputGetter, this.checkRequired()});
        }

        public Void doubleShape(DoubleShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void floatShape(FloatShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void blobShape(BlobShape shape) {
            BuilderGenerator.this.writer.write((Object)"$L$T::encode64($L).strip$L", new Object[]{this.dataSetter, RubyImportContainer.BASE64, this.inputGetter, this.checkRequired()});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            BuilderGenerator.this.writer.write((Object)"$L$L$L", new Object[]{this.dataSetter, TimestampFormat.serializeTimestamp((TimestampShape)shape, (MemberShape)this.memberShape, (String)this.inputGetter, (TimestampFormatTrait.Format)TimestampFormatTrait.Format.DATE_TIME, (boolean)false), this.checkRequired()});
            return null;
        }

        private void defaultComplexSerializer(Shape shape) {
            if (this.checkRequired) {
                BuilderGenerator.this.writer.write((Object)"$1LBuilders::$2L.build($3L) unless $3L.nil?", new Object[]{this.dataSetter, BuilderGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter});
            } else {
                BuilderGenerator.this.writer.write((Object)"$1L(Builders::$2L.build($3L) unless $3L.nil?)", new Object[]{this.dataSetter, BuilderGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter});
            }
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }
    }
}

