/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.traits;

import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RailsJsonTrait
extends AbstractTrait
implements ToSmithyBuilder<RailsJsonTrait> {
    public static final ShapeId ID = ShapeId.from((String)"smithy.ruby.protocols#railsJson");
    private final String errorLocation;

    private RailsJsonTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.errorLocation = builder.errorLocation;
    }

    public Optional<String> getErrorLocation() {
        return Optional.ofNullable(this.errorLocation);
    }

    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("errorLocation", this.getErrorLocation().map(Node::from));
    }

    public Builder toBuilder() {
        return (Builder)RailsJsonTrait.builder().errorLocation(this.errorLocation).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<RailsJsonTrait, Builder> {
        private String errorLocation;

        public Builder errorLocation(String errorLocation) {
            this.errorLocation = errorLocation;
            return this;
        }

        public RailsJsonTrait build() {
            return new RailsJsonTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public RailsJsonTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            String errorLocationValue = objectNode.getMember("errorLocation").map(v -> v.expectStringNode().getValue()).orElse(null);
            return ((Builder)RailsJsonTrait.builder().sourceLocation((FromSourceLocation)value)).errorLocation(errorLocationValue).build();
        }
    }
}

