/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.util;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;
import software.amazon.smithy.utils.IoUtils;

public final class RubySource {
    private RubySource() {
    }

    public static WriteAdditionalFiles rubySource(String rubyFile, String destPath) {
        return context -> {
            String gemName = context.settings().getGemName();
            String gemModule = context.settings().getModule();
            Path path = Paths.get(rubyFile, new String[0]);
            String relativeName = Paths.get(destPath, path.getFileName().toString()).toString();
            String fileName = Paths.get(gemName, "lib", gemName, relativeName).toString();
            String resourcePath = Paths.get("ruby", rubyFile).toString();
            InputStream io = RubySource.class.getClassLoader().getResourceAsStream(resourcePath);
            if (io == null) {
                throw new SmithyBuildException("Unable to find rubySource file in resources: " + resourcePath);
            }
            String fileContent = IoUtils.toUtf8String((InputStream)io);
            RubyCodeWriter writer = new RubyCodeWriter(gemModule);
            ((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("module $L", new Object[]{gemModule})).write(fileContent, new Object[0])).closeBlock("end", new Object[0]);
            context.fileManifest().writeFile(fileName, writer.toString());
            return Collections.singletonList(relativeName);
        };
    }
}

