/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.util;

import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class NodeToHash
implements NodeVisitor<String> {
    public String arrayNode(ArrayNode node) {
        String elements = node.getElements().stream().map(element -> (String)element.accept((NodeVisitor)this)).collect(Collectors.joining(", "));
        return "[" + elements + "]";
    }

    public String booleanNode(BooleanNode node) {
        return node.getValue() ? "true" : "false";
    }

    public String nullNode(NullNode node) {
        return "nil";
    }

    public String numberNode(NumberNode node) {
        return node.getValue().toString();
    }

    public String objectNode(ObjectNode node) {
        Map members = node.getMembers();
        String memberStr = members.keySet().stream().map(k -> "'" + RubyFormatter.toSnakeCase(k.toString()) + "' => " + (String)((Node)members.get(k)).accept((NodeVisitor)this)).collect(Collectors.joining(", "));
        return "{" + memberStr + "}";
    }

    public String stringNode(StringNode node) {
        return "'" + node.getValue() + "'";
    }
}

